/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.support.ui.provider.AbstractLabelProvider;
import org.eclipse.chemclipse.support.ui.provider.ListContentProvider;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.EditorUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ChromatogramDataSupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ChromatogramEditorDialog
extends Dialog {
    private static final int WIDTH = 450;
    private static final int HEIGHT = 150;
    private IChromatogram chromatogramMaster = null;
    private IChromatogramSelection chromatogramSelection = null;
    private ComboViewer comboViewer;
    private EditorUpdateSupport editorUpdateSupport = new EditorUpdateSupport();

    public ChromatogramEditorDialog(Shell parentShell) {
        this(parentShell, null);
    }

    public ChromatogramEditorDialog(Shell parentShell, IChromatogram chromatogramMaster) {
        super(parentShell);
        this.chromatogramMaster = chromatogramMaster;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Chromatogram Editor");
    }

    public IChromatogramSelection getChromatogramSelection() {
        return this.chromatogramSelection;
    }

    protected Point getInitialSize() {
        return new Point(450, 150);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(1, false);
        layout.marginRight = 10;
        layout.marginLeft = 10;
        composite.setLayout((Layout)layout);
        this.createLabel(composite);
        this.createComboViewer(composite);
        return composite;
    }

    private void createLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Select an editor chromatogam.");
    }

    private void createComboViewer(Composite parent) {
        this.comboViewer = new ComboViewer(parent, 8);
        Combo combo = this.comboViewer.getCombo();
        this.comboViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IChromatogramSelection) {
                    IChromatogramSelection chromatogramSelection = (IChromatogramSelection)element;
                    String name = chromatogramSelection.getChromatogram().getName();
                    String type = ChromatogramDataSupport.getChromatogramType(chromatogramSelection);
                    return ChromatogramEditorDialog.this.getChromatogramLabel(name, type, "Editor");
                }
                return null;
            }
        });
        combo.setToolTipText("Select a chromatogram.");
        GridData gridData = new GridData(768);
        gridData.widthHint = 150;
        combo.setLayoutData((Object)gridData);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = ChromatogramEditorDialog.this.comboViewer.getStructuredSelection().getFirstElement();
                if (object instanceof IChromatogramSelection) {
                    ChromatogramEditorDialog.this.chromatogramSelection = (IChromatogramSelection)object;
                }
            }
        });
        this.updateComboViewer(this.chromatogramMaster);
    }

    private String getChromatogramLabel(String name, String type, String defaultName) {
        String label = name == null || "".equals(name.trim()) ? String.valueOf(defaultName) + type : String.valueOf(name) + " " + type;
        return label;
    }

    private void updateComboViewer(IChromatogram chromatogramMaster) {
        List<IChromatogramSelection> chromatogramSelections = this.editorUpdateSupport.getChromatogramSelections();
        if (chromatogramMaster != null) {
            ArrayList<IChromatogramSelection> removeSelections = new ArrayList<IChromatogramSelection>();
            for (IChromatogramSelection chromatogramSelection : chromatogramSelections) {
                if (chromatogramSelection.getChromatogram() != chromatogramMaster) continue;
                removeSelections.add(chromatogramSelection);
            }
            chromatogramSelections.removeAll(removeSelections);
        }
        this.comboViewer.setInput(chromatogramSelections);
    }
}

