/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.custom;

import java.util.HashSet;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.ux.extension.xxd.ui.custom.ChromatogramPeakChart;
import org.eclipse.chemclipse.ux.extension.xxd.ui.custom.IPeakDetectorListener;
import org.eclipse.chemclipse.ux.extension.xxd.ui.custom.PeakDetectorSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.BaselineSelectionPaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.ICustomPaintListener;
import org.eclipse.swtchart.IPlotArea;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.extensions.core.BaseChart;

public class ManualPeakDetectorChart
extends ChromatogramPeakChart {
    private Cursor defaultCursor;
    private int xStart;
    private int yStart;
    private int xStop;
    private int yStop;
    private IChromatogram<? extends IPeak> chromatogram;
    private BaselineSelectionPaintListener baselineSelectionPaintListener;
    private IPeakDetectorListener peakDetectorListener = null;
    private boolean manualDetectionEnabled = false;

    public ManualPeakDetectorChart() {
        this.init();
    }

    public ManualPeakDetectorChart(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    public void addPeakDetectorListener(IPeakDetectorListener peakDetectorListener) {
        this.peakDetectorListener = peakDetectorListener;
    }

    public void removePeakDetectorListener() {
        this.peakDetectorListener = null;
    }

    public boolean isManualDetectionEnabled() {
        return this.manualDetectionEnabled;
    }

    public void setManualDetectionEnabled(boolean manualDetectionEnabled) {
        this.manualDetectionEnabled = manualDetectionEnabled;
    }

    public void setChromatogram(IChromatogram<? extends IPeak> chromatogram) {
        this.chromatogram = chromatogram;
    }

    public void handleMouseDownEvent(Event event) {
        super.handleMouseDownEvent(event);
        if (this.manualDetectionEnabled && this.isControlKeyPressed(event)) {
            this.startBaselineSelection(event.x, event.y);
            this.setCursor(2);
        }
    }

    public void handleMouseMoveEvent(Event event) {
        super.handleMouseMoveEvent(event);
        if (this.manualDetectionEnabled && this.isControlKeyPressed(event) && this.xStart > 0 && this.yStart > 0) {
            this.trackBaselineSelection(event.x, event.y);
        }
    }

    public void handleMouseUpEvent(Event event) {
        super.handleMouseUpEvent(event);
        if (this.manualDetectionEnabled && this.isControlKeyPressed(event)) {
            this.stopBaselineSelection(event.x, event.y);
            this.extractPeak();
            this.setCursorDefault();
            this.resetSelectedRange();
        }
    }

    private void init() {
        this.defaultCursor = this.getBaseChart().getCursor();
        IPlotArea plotArea = this.getBaseChart().getPlotArea();
        this.baselineSelectionPaintListener = new BaselineSelectionPaintListener();
        plotArea.addCustomPaintListener((ICustomPaintListener)this.baselineSelectionPaintListener);
    }

    private boolean isControlKeyPressed(Event event) {
        return (event.stateMask & 0x40000) == 262144;
    }

    private void startBaselineSelection(int x, int y) {
        this.xStart = x;
        this.yStart = y;
        this.baselineSelectionPaintListener.setX1(this.xStart);
        this.baselineSelectionPaintListener.setY1(this.yStart);
    }

    private void trackBaselineSelection(int x, int y) {
        this.xStop = x;
        this.yStop = y;
        this.baselineSelectionPaintListener.setX1(this.xStart);
        this.baselineSelectionPaintListener.setY1(this.yStart);
        this.baselineSelectionPaintListener.setX2(this.xStop);
        this.baselineSelectionPaintListener.setY2(this.yStop);
        this.redrawChart();
    }

    private void stopBaselineSelection(int x, int y) {
        this.xStop = x;
        this.yStop = y;
    }

    private void resetSelectedRange() {
        this.baselineSelectionPaintListener.reset();
        this.xStart = 0;
        this.yStart = 0;
        this.xStop = 0;
        this.yStop = 0;
        this.redrawChart();
    }

    private void setCursor(int cursorId) {
        this.getBaseChart().setCursor(this.getBaseChart().getDisplay().getSystemCursor(cursorId));
    }

    private void setCursorDefault() {
        this.getBaseChart().setCursor(this.defaultCursor);
    }

    private void redrawChart() {
        this.getBaseChart().redraw();
    }

    private void extractPeak() {
        IPeak peak;
        if (this.chromatogram != null && (peak = this.extractPeakFromUserSelection(this.xStart, this.yStart, this.xStop, this.yStop)) != null && this.peakDetectorListener != null) {
            this.peakDetectorListener.update(this.chromatogram, peak);
        }
    }

    private IPeak extractPeakFromUserSelection(int xStart, int yStart, int xStop, int yStop) {
        IPeak peak = null;
        if (this.chromatogram != null) {
            Point rectangle = this.getBaseChart().getPlotArea().getSize();
            int width = rectangle.x;
            double factorWidth = 0.0;
            if (width != 0) {
                factorWidth = 100.0 / (double)width;
                double percentageStartWidth = factorWidth * (double)xStart / 100.0;
                double percentageStopWidth = factorWidth * (double)xStop / 100.0;
                BaseChart baseChart = this.getBaseChart();
                IAxis retentionTime = baseChart.getAxisSet().getXAxis(0);
                Range millisecondsRange = retentionTime.getRange();
                double millisecondsWidth = millisecondsRange.upper - millisecondsRange.lower;
                int startRetentionTime = (int)(millisecondsRange.lower + millisecondsWidth * percentageStartWidth);
                int stopRetentionTime = (int)(millisecondsRange.lower + millisecondsWidth * percentageStopWidth);
                HashSet<Integer> traces = new HashSet<Integer>();
                boolean includeBackground = true;
                boolean optimizeRange = true;
                peak = PeakDetectorSupport.extractPeakByRetentionTime(this.chromatogram, startRetentionTime, stopRetentionTime, includeBackground, optimizeRange, traces);
            }
        }
        return peak;
    }
}

