/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.junit.jupiter.api.AssertionUtils;

class AssertFalse {
    private static final String EXPECTED_FALSE = "expected: <false> but was: <true>";

    private AssertFalse() {
    }

    static void assertFalse(boolean condition) {
        AssertFalse.assertFalse(condition, (String)null);
    }

    static void assertFalse(boolean condition, String message) {
        if (condition) {
            AssertionUtils.fail(AssertionUtils.buildPrefix(message) + EXPECTED_FALSE);
        }
    }

    static void assertFalse(boolean condition, Supplier<String> messageSupplier) {
        if (condition) {
            AssertionUtils.fail(AssertionUtils.buildPrefix(AssertionUtils.nullSafeGet(messageSupplier)) + EXPECTED_FALSE);
        }
    }

    static void assertFalse(BooleanSupplier booleanSupplier) {
        AssertFalse.assertFalse(booleanSupplier.getAsBoolean(), (String)null);
    }

    static void assertFalse(BooleanSupplier booleanSupplier, String message) {
        AssertFalse.assertFalse(booleanSupplier.getAsBoolean(), message);
    }

    static void assertFalse(BooleanSupplier booleanSupplier, Supplier<String> messageSupplier) {
        AssertFalse.assertFalse(booleanSupplier.getAsBoolean(), messageSupplier);
    }
}

