/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.gson.io;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramGson_1000 {
    public static final String MGC = "BSPW";
    public static final String VERSION = "1.0.0.0";
    private static final String SHARE_MGC = "SHARE_MGC";
    private static final String SHARE_VERSION = "VERSION";
    private static final String SHARE_GUID = "GUID";
    private static final String NAME = "NAME";
    private static final String CHROMATOGRAM = "CHROMATOGRAM";
    private static final String DATA_NAME = "DATA_NAME";
    private static final String TYPE = "TYPE";
    private static final String DATE = "DATE";
    private static final String OPERATOR = "OPERATOR";
    private static final String BARCODE = "BARCODE";
    private static final String RTS = "RTS";
    private static final String RT = "RT";
    private static final String RI = "RI";
    private static final String TIC = "TIC";
    private static final String MS = "MS";
    private static final String IONS = "IONS";
    private static final String INTENSITIES = "INTENSITIES";
    private static final String START_RT = "START_RT";
    private static final String STOP_RT = "STOP_RT";
    private static final String LEADING = "LEADING";
    private static final String TAILING = "TAILING";
    private static final String AREA = "AREA";
    private static final String SN = "SN";
    private static final String HEIGHT = "HEIGHT";
    private static final String GRADIENT_ANGLE = "GRADIENT_ANGLE";
    private static final String START_BASELINE = "START_BASELINE";
    private static final String STOP_BASELINE = "STOP_BASELINE";
    private static final String TARGETS = "TARGETS";
    private static final String CAS = "CAS";
    private static final String MF = "MF";
    private static final String RMF = "RMF";
    private static final String MFD = "MFD";
    private static final String RMFD = "RMFD";
    private static final String PROB = "PROB";
    private static final String FORMULA = "FORMULA";
    private static final String SMILES = "SMILES";
    private static final String INCHI = "INCHI";
    private static final String MW = "MW";
    private static final String MISC = "MISC";
    private static final String CONTR = "CONTR";
    private static final String DB = "DB";
    private static final String IDENTIFIER = "IDENTIFIER";
    private static final String ADVISE = "ADVISE";
    private static final String SECTION_OVERVIEW = "SECTION_OVERVIEW";
    private static final String SECTION_IDENTIFIED_SCANS = "SECTION_IDENTIFIED_SCANS";
    private static final String SECTION_IDENTIFIED_PEAKS = "SECTION_IDENTIFIED_PEAKS";

    public String getJSON(IChromatogramMSD chromatogram, IProgressMonitor monitor) {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put(SHARE_MGC, MGC);
        jsonMap.put(SHARE_VERSION, VERSION);
        jsonMap.put(SHARE_GUID, UUID.randomUUID().toString());
        Map<String, Object> chromatogramMap = this.getChromatogramMap(chromatogram);
        jsonMap.put(CHROMATOGRAM, chromatogramMap);
        this.addSectionChromatogramOverview(chromatogram, chromatogramMap);
        this.addSectionIdentifiedScans(chromatogram, chromatogramMap);
        this.addSectionIdentifiedPeaks(chromatogram, chromatogramMap);
        Gson gson = new Gson();
        return gson.toJson(jsonMap);
    }

    private Map<String, Object> getChromatogramMap(IChromatogramMSD chromatogram) {
        HashMap<String, Object> chromatogramMap = new HashMap<String, Object>();
        chromatogramMap.put(NAME, chromatogram.getName());
        chromatogramMap.put(DATA_NAME, chromatogram.getDataName());
        chromatogramMap.put(OPERATOR, chromatogram.getOperator());
        chromatogramMap.put(BARCODE, chromatogram.getBarcode());
        chromatogramMap.put(TYPE, "");
        chromatogramMap.put(DATE, chromatogram.getDate().toString());
        return chromatogramMap;
    }

    private void addSectionChromatogramOverview(IChromatogramMSD chromatogram, Map<String, Object> chromatogramMap) {
        HashMap sectionOverview = new HashMap();
        ArrayList<Integer> retentionTimes = new ArrayList<Integer>();
        ArrayList<Float> retentionIndices = new ArrayList<Float>();
        ArrayList<Float> totalIntensities = new ArrayList<Float>();
        for (IScan scan : chromatogram.getScans()) {
            retentionTimes.add(scan.getRetentionTime());
            retentionIndices.add(Float.valueOf(scan.getRetentionIndex()));
            totalIntensities.add(Float.valueOf(scan.getTotalSignal()));
        }
        sectionOverview.put(RT, retentionTimes);
        sectionOverview.put(RI, retentionIndices);
        sectionOverview.put(TIC, totalIntensities);
        chromatogramMap.put(SECTION_OVERVIEW, sectionOverview);
    }

    private void addSectionIdentifiedScans(IChromatogramMSD chromatogram, Map<String, Object> chromatogramMap) {
        ArrayList<Map<String, Object>> identifiedScans = new ArrayList<Map<String, Object>>();
        for (IScan scan : chromatogram.getScans()) {
            IScanMSD scanMSD;
            if (!(scan instanceof IScanMSD) || (scanMSD = (IScanMSD)scan).getTargets().size() <= 0) continue;
            Map<String, Object> scanMap = this.getScanMap(scanMSD);
            scanMap.put(TARGETS, this.getTargetList(scanMSD.getTargets()));
            identifiedScans.add(scanMap);
        }
        chromatogramMap.put(SECTION_IDENTIFIED_SCANS, identifiedScans);
    }

    private void addSectionIdentifiedPeaks(IChromatogramMSD chromatogram, Map<String, Object> chromatogramMap) {
        ArrayList<Map<String, Object>> peakList = new ArrayList<Map<String, Object>>();
        for (IChromatogramPeakMSD peak : chromatogram.getPeaks()) {
            Map<String, Object> peakMap = this.getPeakMap(peak);
            peakMap.put(MS, this.getScanMap((IScanMSD)peak.getExtractedMassSpectrum()));
            peakMap.put(TARGETS, this.getTargetList(peak.getTargets()));
            peakList.add(peakMap);
        }
        chromatogramMap.put(SECTION_IDENTIFIED_PEAKS, peakList);
    }

    private Map<String, Object> getScanMap(IScanMSD scanMSD) {
        HashMap<String, Object> scanMap = new HashMap<String, Object>();
        scanMap.put(RT, scanMSD.getRetentionTime());
        scanMap.put(RI, Float.valueOf(scanMSD.getRetentionIndex()));
        scanMap.put(TIC, Float.valueOf(scanMSD.getTotalSignal()));
        ArrayList<Double> ions = new ArrayList<Double>();
        ArrayList<Float> intensities = new ArrayList<Float>();
        for (IIon ion : scanMSD.getIons()) {
            ions.add(ion.getIon());
            intensities.add(Float.valueOf(ion.getAbundance()));
        }
        scanMap.put(IONS, ions);
        scanMap.put(INTENSITIES, intensities);
        return scanMap;
    }

    private Map<String, Object> getPeakMap(IChromatogramPeakMSD peak) {
        HashMap<String, Object> peakMap = new HashMap<String, Object>();
        IPeakModelMSD peakModel = peak.getPeakModel();
        int startRetentionTime = peakModel.getStartRetentionTime();
        int stopRetentionTime = peakModel.getStopRetentionTime();
        peakMap.put(START_RT, startRetentionTime);
        peakMap.put(STOP_RT, stopRetentionTime);
        peakMap.put(LEADING, Float.valueOf(peakModel.getLeading()));
        peakMap.put(TAILING, Float.valueOf(peakModel.getTailing()));
        peakMap.put(AREA, peak.getIntegratedArea());
        peakMap.put(SN, Float.valueOf(peak.getSignalToNoiseRatio()));
        peakMap.put(HEIGHT, Float.valueOf(peakModel.getPeakMaximum().getTotalSignal()));
        peakMap.put(GRADIENT_ANGLE, peakModel.getGradientAngle());
        peakMap.put(START_BASELINE, Float.valueOf(peakModel.getBackgroundAbundance(startRetentionTime)));
        peakMap.put(STOP_BASELINE, Float.valueOf(peakModel.getBackgroundAbundance(stopRetentionTime)));
        List retentionTimes = peakModel.getRetentionTimes();
        ArrayList<Float> intensities = new ArrayList<Float>();
        for (Integer retentionTime : retentionTimes) {
            intensities.add(Float.valueOf(peakModel.getPeakAbundance(retentionTime.intValue())));
        }
        peakMap.put(RTS, retentionTimes);
        peakMap.put(INTENSITIES, intensities);
        return peakMap;
    }

    private List<Map<String, Object>> getTargetList(Set<IIdentificationTarget> identificationTargets) {
        ArrayList<Map<String, Object>> targetList = new ArrayList<Map<String, Object>>();
        for (IIdentificationTarget identificationTarget : identificationTargets) {
            HashMap<String, Object> targetMap = new HashMap<String, Object>();
            IComparisonResult comparisonResult = identificationTarget.getComparisonResult();
            ILibraryInformation libraryInformation = identificationTarget.getLibraryInformation();
            targetMap.put(NAME, libraryInformation.getName());
            targetMap.put(CAS, libraryInformation.getCasNumber());
            targetMap.put(MF, Float.valueOf(comparisonResult.getMatchFactor()));
            targetMap.put(MFD, Float.valueOf(comparisonResult.getMatchFactorDirect()));
            targetMap.put(RMF, Float.valueOf(comparisonResult.getReverseMatchFactor()));
            targetMap.put(RMFD, Float.valueOf(comparisonResult.getReverseMatchFactorDirect()));
            targetMap.put(PROB, Float.valueOf(comparisonResult.getProbability()));
            targetMap.put(FORMULA, libraryInformation.getFormula());
            targetMap.put(SMILES, libraryInformation.getSmiles());
            targetMap.put(INCHI, libraryInformation.getInChI());
            targetMap.put(MW, libraryInformation.getMolWeight());
            targetMap.put(MISC, libraryInformation.getMiscellaneous());
            targetMap.put(CONTR, libraryInformation.getContributor());
            targetMap.put(DB, libraryInformation.getDatabase());
            targetMap.put(IDENTIFIER, libraryInformation.getReferenceIdentifier());
            targetMap.put(ADVISE, comparisonResult.getAdvise());
            targetList.add(targetMap);
        }
        return targetList;
    }
}

