/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.model.xwc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.core.Point;
import org.eclipse.chemclipse.numeric.equations.Equations;
import org.eclipse.chemclipse.numeric.equations.LinearEquation;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.IScanWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.chemclipse.wsd.model.core.support.IMarkedWavelength;
import org.eclipse.chemclipse.wsd.model.core.support.IMarkedWavelengths;
import org.eclipse.chemclipse.wsd.model.core.support.MarkedWavelengths;
import org.eclipse.chemclipse.wsd.model.xwc.ExtractedSingleWavelengthSignal;
import org.eclipse.chemclipse.wsd.model.xwc.ExtractedSingleWavelengthSignals;
import org.eclipse.chemclipse.wsd.model.xwc.IExtractedSingleWavelengthSignal;
import org.eclipse.chemclipse.wsd.model.xwc.IExtractedSingleWavelengthSignalExtractor;
import org.eclipse.chemclipse.wsd.model.xwc.IExtractedSingleWavelengthSignals;

public class ExtractedSingleWavelengthSignalExtractor
implements IExtractedSingleWavelengthSignalExtractor {
    private IChromatogramWSD chromatogram;
    private boolean joinSignal;

    public ExtractedSingleWavelengthSignalExtractor(IChromatogramWSD chromatogram, boolean joinSignal) throws ChromatogramIsNullException {
        if (chromatogram == null) {
            throw new ChromatogramIsNullException();
        }
        this.chromatogram = chromatogram;
        this.joinSignal = joinSignal;
    }

    @Override
    public List<IExtractedSingleWavelengthSignals> getExtractedWavelengthSignals(IChromatogramSelectionWSD chromatogramSelection) {
        int startScan = this.chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
        int stopScan = this.chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
        return this.getExtractedWavelengthSignals(startScan, stopScan);
    }

    @Override
    public List<IExtractedSingleWavelengthSignals> getExtractedWavelengthSignals(int startScan, int stopScan, IMarkedWavelengths markedWavelengths) {
        return this.getExtractedWavelengthSignals(startScan, stopScan, markedWavelengths, this.joinSignal);
    }

    private List<IExtractedSingleWavelengthSignals> getExtractedWavelengthSignals(int startScan, int stopScan, IMarkedWavelengths markedWavelengths, boolean join) {
        if (startScan > stopScan) {
            int tmp = startScan;
            startScan = stopScan;
            stopScan = tmp;
        }
        ArrayList<IExtractedSingleWavelengthSignals> extractedWavelengthSignals = new ArrayList<IExtractedSingleWavelengthSignals>();
        if (startScan < 1 && stopScan > this.getNumberOfScansWithWavelengths(this.chromatogram)) {
            extractedWavelengthSignals.add(new ExtractedSingleWavelengthSignals(0, Double.NaN, this.chromatogram));
            return extractedWavelengthSignals;
        }
        Iterator itWavelengths = markedWavelengths.getWavelengths().stream().sorted().iterator();
        while (itWavelengths.hasNext()) {
            double wavelength = (Double)itWavelengths.next();
            TreeMap<Integer, IExtractedSingleWavelengthSignal> extractedSignalsMap = null;
            int startScanSignal = 0;
            int stopScanSignal = 0;
            int scan = startScan;
            while (scan <= stopScan) {
                IScanWSD iScanWSD = this.chromatogram.getSupplierScan(scan);
                if (iScanWSD.getScanSignals().size() > 0) {
                    Optional<IExtractedSingleWavelengthSignal> extractedWavelengthSignal = iScanWSD.getExtractedSingleWavelengthSignal(wavelength);
                    if (extractedWavelengthSignal.isPresent()) {
                        if (extractedSignalsMap == null) {
                            extractedSignalsMap = new TreeMap<Integer, IExtractedSingleWavelengthSignal>();
                            extractedSignalsMap.put(scan, (IExtractedSingleWavelengthSignal)extractedWavelengthSignal.get());
                            startScanSignal = scan;
                            stopScanSignal = scan;
                        } else {
                            extractedSignalsMap.put(scan, (IExtractedSingleWavelengthSignal)extractedWavelengthSignal.get());
                            stopScanSignal = scan;
                        }
                    } else if (extractedSignalsMap != null && !join) {
                        ExtractedSingleWavelengthSignals extractedSingleWavelengthSignals = new ExtractedSingleWavelengthSignals(startScanSignal, stopScanSignal, wavelength, this.chromatogram);
                        for (Map.Entry entry : extractedSignalsMap.entrySet()) {
                            extractedSingleWavelengthSignals.add((IExtractedSingleWavelengthSignal)entry.getValue());
                        }
                        extractedWavelengthSignals.add(extractedSingleWavelengthSignals);
                        extractedSignalsMap = null;
                    }
                }
                ++scan;
            }
            if (extractedSignalsMap == null) continue;
            if (!join) {
                ExtractedSingleWavelengthSignals extractedSingleWavelengthSignals = new ExtractedSingleWavelengthSignals(startScanSignal, stopScanSignal, wavelength, this.chromatogram);
                for (Map.Entry entry : extractedSignalsMap.entrySet()) {
                    extractedSingleWavelengthSignals.add((IExtractedSingleWavelengthSignal)entry.getValue());
                }
                extractedWavelengthSignals.add(extractedSingleWavelengthSignals);
                continue;
            }
            ExtractedSingleWavelengthSignals extractedIonSignals = new ExtractedSingleWavelengthSignals(startScanSignal, stopScanSignal, wavelength, this.chromatogram);
            Iterator iterator = extractedSignalsMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                int scanNumber = (Integer)entry.getKey();
                IExtractedSingleWavelengthSignal extractedSingleWavelengthSignal = (IExtractedSingleWavelengthSignal)entry.getValue();
                if (iterator.hasNext()) {
                    entry = iterator.next();
                    int scanNumberNext = (Integer)entry.getKey();
                    IExtractedSingleWavelengthSignal extractedSingleWavelengthSignalNext = (IExtractedSingleWavelengthSignal)entry.getValue();
                    extractedIonSignals.add(extractedSingleWavelengthSignal);
                    if (scanNumber + 1 != scanNumberNext) {
                        Point p1 = new Point((double)extractedSingleWavelengthSignal.getRetentionTime(), (double)extractedSingleWavelengthSignal.getTotalSignal());
                        Point p2 = new Point((double)extractedSingleWavelengthSignalNext.getRetentionTime(), (double)extractedSingleWavelengthSignalNext.getTotalSignal());
                        LinearEquation eq = Equations.createLinearEquation((IPoint)p1, (IPoint)p2);
                        int i = scanNumber + 1;
                        while (i < scanNumberNext) {
                            IScan s = this.chromatogram.getScan(i);
                            int retentionTime = s.getRetentionTime();
                            float retentionIndex = s.getRetentionIndex();
                            extractedIonSignals.add(new ExtractedSingleWavelengthSignal(wavelength, (float)eq.calculateY((double)retentionTime), retentionTime, retentionIndex));
                            ++i;
                        }
                    }
                    extractedIonSignals.add(extractedSingleWavelengthSignalNext);
                    continue;
                }
                extractedIonSignals.add(extractedSingleWavelengthSignal);
            }
            extractedWavelengthSignals.add(extractedIonSignals);
        }
        return extractedWavelengthSignals;
    }

    private int getNumberOfScansWithWavelengths(IChromatogramWSD chromatogram) {
        int counter = 0;
        for (IScan scan : chromatogram.getScans()) {
            IScanWSD scanWSD;
            if (!(scan instanceof IScanWSD) || (scanWSD = (IScanWSD)scan).getScanSignals().size() <= 0) continue;
            ++counter;
        }
        return counter;
    }

    @Override
    public List<IExtractedSingleWavelengthSignals> getExtractedWavelengthSignals() {
        MarkedWavelengths markedWavelengths = new MarkedWavelengths();
        this.chromatogram.getScans().forEach(s -> {
            IScanWSD scanWSD = (IScanWSD)s;
            scanWSD.getScanSignals().forEach(signal -> markedWavelengths.add(signal.getWavelength()));
        });
        return this.getExtractedWavelengthSignals(1, this.chromatogram.getNumberOfScans(), markedWavelengths, this.joinSignal);
    }

    @Override
    public List<IExtractedSingleWavelengthSignals> getExtractedWavelengthSignals(int startScan, int stopScan) {
        MarkedWavelengths markedWavelengths = new MarkedWavelengths();
        int i = startScan;
        while (i <= stopScan) {
            this.chromatogram.getSupplierScan(i).getScanSignals().forEach(signal -> markedWavelengths.add(signal.getWavelength()));
            ++i;
        }
        return this.getExtractedWavelengthSignals(startScan, stopScan, markedWavelengths, this.joinSignal);
    }

    @Override
    public List<IExtractedSingleWavelengthSignals> getExtractedWavelengthSignals(IMarkedWavelengths markedWavelengths) {
        return this.getExtractedWavelengthSignals(1, this.chromatogram.getNumberOfScans(), markedWavelengths, this.joinSignal);
    }

    @Override
    public boolean isJoinSignal() {
        return this.joinSignal;
    }

    @Override
    public Optional<IExtractedSingleWavelengthSignals> getExtractWavelengthContinuousSignal(int startScan, int stopScan, IMarkedWavelength markedWavelength) {
        IExtractedSingleWavelengthSignals extracetedSignal;
        MarkedWavelengths markedWavelengths = new MarkedWavelengths();
        markedWavelengths.add(markedWavelength);
        List<IExtractedSingleWavelengthSignals> extracetedSignals = this.getExtractedWavelengthSignals(startScan, stopScan, markedWavelengths, this.joinSignal);
        if (extracetedSignals.size() == 1 && (extracetedSignal = extracetedSignals.get(0)).getStartScan() == startScan && extracetedSignal.getStopScan() == stopScan) {
            return Optional.of(extracetedSignal);
        }
        return Optional.empty();
    }

    @Override
    public Optional<IExtractedSingleWavelengthSignals> getExtractWavelengthContinuousSignal(IMarkedWavelength markedWavelength) {
        return this.getExtractWavelengthContinuousSignal(1, this.chromatogram.getNumberOfScans(), markedWavelength);
    }

    @Override
    public void setJoinSignal(boolean joinSignal) {
        this.joinSignal = joinSignal;
    }
}

