/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.ionremover.core;

import org.eclipse.chemclipse.chromatogram.filter.result.ChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.chromatogram.AbstractChromatogramFilterMSD;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.ionremover.exceptions.FilterException;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.ionremover.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.ionremover.settings.ChromatogramFilterSettings;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.core.support.MarkedIons;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.support.util.IonSettingUtil;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramFilter
extends AbstractChromatogramFilterMSD {
    public IProcessingInfo applyFilter(IChromatogramSelectionMSD chromatogramSelection, IChromatogramFilterSettings chromatogramFilterSettings, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = this.validate(chromatogramSelection, chromatogramFilterSettings);
        if (!processingInfo.hasErrorMessages() && chromatogramFilterSettings instanceof ChromatogramFilterSettings) {
            try {
                ChromatogramFilterSettings filterSettings = (ChromatogramFilterSettings)chromatogramFilterSettings;
                IonSettingUtil ionSettingUtil = new IonSettingUtil();
                MarkedIons ionsToRemove = new MarkedIons(ionSettingUtil.extractIons(ionSettingUtil.deserialize(filterSettings.getIonsToRemove())), IMarkedIons.IonMarkMode.INCLUDE);
                this.applyIonRemoverFilter(chromatogramSelection, (IMarkedIons)ionsToRemove, monitor);
                processingInfo.setProcessingResult((Object)new ChromatogramFilterResult(ResultStatus.OK, "Mass fragments have been removed successfully."));
            }
            catch (FilterException e) {
                processingInfo.setProcessingResult((Object)new ChromatogramFilterResult(ResultStatus.EXCEPTION, e.getMessage()));
            }
        }
        return processingInfo;
    }

    public IProcessingInfo applyFilter(IChromatogramSelectionMSD chromatogramSelection, IProgressMonitor monitor) {
        ChromatogramFilterSettings filterSettings = PreferenceSupplier.getFilterSettings();
        return this.applyFilter(chromatogramSelection, (IChromatogramFilterSettings)filterSettings, monitor);
    }

    private void applyIonRemoverFilter(IChromatogramSelectionMSD chromatogramSelection, IMarkedIons ionsToRemove, IProgressMonitor monitor) throws FilterException {
        if (ionsToRemove == null) {
            throw new FilterException("The excluded ions instance was null.");
        }
        if (ionsToRemove.getIonsNominal().size() == 0) {
            throw new FilterException("There was no ion stored to be excluded.");
        }
        IChromatogramMSD chromatogram = chromatogramSelection.getChromatogramMSD();
        int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
        int stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
        int scan = startScan;
        while (scan <= stopScan) {
            monitor.subTask("Remove ions from scan: " + scan);
            IVendorMassSpectrum supplierMassSpectrum = chromatogram.getSupplierScan(scan);
            supplierMassSpectrum.removeIons(ionsToRemove);
            ++scan;
        }
    }
}

