/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.swt;

import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.IPreprocessingSettings;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.PreprocessingSettings;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.CenteringMean;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.CenteringMedian;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.ICentering;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.INormalization;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.IPreprocessing;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.IReplacer;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.ITransformation;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.MeanValuesReplacer;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.MedianValuesReplacer;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.Normalization1Norm;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.Normalization2Norm;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.NormalizationInfNorm;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.ScalingAuto;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.ScalingLevel;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.ScalingPareto;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.ScalingRange;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.ScalingVast;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.SmallValuesReplacer;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.TransformationLOG10;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.TransformationPower;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.Activator;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractLabelProvider;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PreprocessingSettingsUI
extends Composite {
    private static final String KEY_IMAGE = "IMAGE";
    private static final String LABEL_NORMALIZE = "Normalize Data:";
    private static final String LABEL_REPLACE = "Replace Data:";
    private static final String LABEL_TRANSFORM = "Transform Data:";
    private static final String LABEL_CENTER = "Center Data:";
    private static final String LABEL_SCALE = "Scale Data:";
    private IPreprocessingSettings preprocessingSettings = new PreprocessingSettings();
    private ComboViewer comboViewerNormalize;
    private ComboViewer comboViewerReplacer;
    private ComboViewer comboViewerTransformation;
    private ComboViewer comboViewerCentering;
    private ComboViewer comboViewerScaling;
    private Button checkBoxRemove;
    private Button checkBoxSelect;
    private Label labelFormula;
    private Canvas canvasFormula;
    private Object[] normalizeInput = new Object[]{"--", new Normalization1Norm(), new Normalization2Norm(), new NormalizationInfNorm()};
    private Object[] replacerInput = new Object[]{new MeanValuesReplacer(), new MedianValuesReplacer(), new SmallValuesReplacer()};
    private Object[] transformationInput = new Object[]{"--", new TransformationLOG10(), new TransformationPower()};
    private Object[] centeringInput = new Object[]{"--", new CenteringMean(), new CenteringMedian()};
    private Object[] scaleInputEmpty = new Object[]{"--"};
    private Object[] scalingInputMean = this.createScaleElements(1);
    private Object[] scalingInputMedian = this.createScaleElements(2);

    public PreprocessingSettingsUI(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void setInput(IPreprocessingSettings preprocessingSettings) {
        this.preprocessingSettings = preprocessingSettings;
        this.updateWidgets();
    }

    public IPreprocessingSettings getPreprocessingSettings() {
        return this.preprocessingSettings;
    }

    private void createControl() {
        this.setLayout((Layout)new GridLayout(3, false));
        this.createLabel(this, LABEL_NORMALIZE);
        this.comboViewerNormalize = this.createComboViewerNormalize(this);
        this.createButtonInfoFormula(this, this.comboViewerNormalize);
        this.createLabel(this, LABEL_REPLACE);
        this.comboViewerReplacer = this.createComboViewerReplace(this);
        this.createButtonInfoFormula(this, this.comboViewerReplacer);
        this.createLabel(this, LABEL_TRANSFORM);
        this.comboViewerTransformation = this.createComboViewerTransform(this);
        this.createButtonInfoFormula(this, this.comboViewerTransformation);
        this.createLabel(this, LABEL_CENTER);
        this.comboViewerCentering = this.createComboViewerCenter(this);
        this.createButtonInfoFormula(this, this.comboViewerCentering);
        this.createLabel(this, LABEL_SCALE);
        this.comboViewerScaling = this.createComboViewerScale(this);
        this.createButtonInfoFormula(this, this.comboViewerScaling);
        this.checkBoxRemove = this.createCheckBoxRemoveVariables(this);
        this.checkBoxSelect = this.createCheckBoxSelectVariables(this);
        this.labelFormula = this.createLabelFormula(this);
        this.canvasFormula = this.createCanvas(this);
    }

    private Label createLabelFormula(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        composite.setLayoutData((Object)gridData);
        return this.createLabel(composite, "Formula:");
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        return label;
    }

    private ComboViewer createComboViewerNormalize(Composite parent) {
        final ComboViewer comboViewer = this.createComboViewer(parent, this.normalizeInput, "Normalization");
        Combo combo = comboViewer.getCombo();
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = comboViewer.getStructuredSelection().getFirstElement();
                if (object instanceof INormalization) {
                    PreprocessingSettingsUI.this.preprocessingSettings.setNormalization((INormalization)object);
                } else {
                    PreprocessingSettingsUI.this.preprocessingSettings.setNormalization(null);
                }
                PreprocessingSettingsUI.this.updateFormulaDescription(comboViewer);
            }
        });
        return comboViewer;
    }

    private ComboViewer createComboViewerReplace(Composite parent) {
        final ComboViewer comboViewer = this.createComboViewer(parent, this.replacerInput, "Replacement");
        Combo combo = comboViewer.getCombo();
        combo.select(0);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = comboViewer.getStructuredSelection().getFirstElement();
                if (object instanceof IReplacer) {
                    PreprocessingSettingsUI.this.preprocessingSettings.setReplacer((IReplacer)object);
                } else {
                    PreprocessingSettingsUI.this.preprocessingSettings.setReplacer(null);
                }
                PreprocessingSettingsUI.this.updateFormulaDescription(comboViewer);
            }
        });
        return comboViewer;
    }

    private ComboViewer createComboViewerTransform(Composite parent) {
        final ComboViewer comboViewer = this.createComboViewer(parent, this.transformationInput, "Transformation");
        Combo combo = comboViewer.getCombo();
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = comboViewer.getStructuredSelection().getFirstElement();
                if (object instanceof ITransformation) {
                    PreprocessingSettingsUI.this.preprocessingSettings.setTransformation((ITransformation)object);
                } else {
                    PreprocessingSettingsUI.this.preprocessingSettings.setTransformation(null);
                }
                PreprocessingSettingsUI.this.updateFormulaDescription(comboViewer);
            }
        });
        return comboViewer;
    }

    private ComboViewer createComboViewerCenter(Composite parent) {
        final ComboViewer comboViewer = this.createComboViewer(parent, this.centeringInput, "Centering");
        Combo combo = comboViewer.getCombo();
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PreprocessingSettingsUI.this.comboViewerScaling != null) {
                    Object object = comboViewer.getStructuredSelection().getFirstElement();
                    PreprocessingSettingsUI.this.preprocessingSettings.setCentering(null);
                    Combo combo = PreprocessingSettingsUI.this.comboViewerScaling.getCombo();
                    if (object instanceof CenteringMean) {
                        PreprocessingSettingsUI.this.comboViewerScaling.setInput((Object)PreprocessingSettingsUI.this.scalingInputMean);
                        combo.setEnabled(true);
                    } else if (object instanceof CenteringMedian) {
                        PreprocessingSettingsUI.this.comboViewerScaling.setInput((Object)PreprocessingSettingsUI.this.scalingInputMedian);
                        combo.setEnabled(true);
                    } else {
                        PreprocessingSettingsUI.this.comboViewerScaling.setInput((Object)PreprocessingSettingsUI.this.scaleInputEmpty);
                        combo.setEnabled(false);
                    }
                }
                PreprocessingSettingsUI.this.updateFormulaDescription(comboViewer);
            }
        });
        return comboViewer;
    }

    private ComboViewer createComboViewerScale(Composite parent) {
        final ComboViewer comboViewer = this.createComboViewer(parent, this.scaleInputEmpty, "Scaling");
        Combo combo = comboViewer.getCombo();
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = comboViewer.getStructuredSelection().getFirstElement();
                if (object instanceof ICentering) {
                    PreprocessingSettingsUI.this.preprocessingSettings.setCentering((ICentering)object);
                } else {
                    PreprocessingSettingsUI.this.preprocessingSettings.setCentering(null);
                }
                PreprocessingSettingsUI.this.updateFormulaDescription(comboViewer);
            }
        });
        return comboViewer;
    }

    private ComboViewer createComboViewer(Composite parent, Object[] input, String tooltip) {
        ComboViewer comboViewer = new ComboViewer(parent, 8);
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setInput((Object)input);
        comboViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IPreprocessing) {
                    return ((IPreprocessing)element).getName();
                }
                if (element instanceof String) {
                    return element.toString();
                }
                return null;
            }
        });
        Combo combo = comboViewer.getCombo();
        combo.select(0);
        combo.setToolTipText(tooltip);
        combo.setLayoutData((Object)new GridData(768));
        return comboViewer;
    }

    private Button createButtonInfoFormula(Composite parent, final ComboViewer comboViewer) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Show the formula.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreprocessingSettingsUI.this.updateFormulaDescription(comboViewer);
            }
        });
        return button;
    }

    private Button createCheckBoxRemoveVariables(Composite parent) {
        final Button button = new Button(parent, 32);
        button.setText("Remove variables, which contain less than two values.");
        button.setToolTipText("Remove Variables");
        button.setSelection(this.preprocessingSettings.isRemoveUselessVariables());
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreprocessingSettingsUI.this.preprocessingSettings.setRemoveUselessVariables(button.getSelection());
            }
        });
        return button;
    }

    private Button createCheckBoxSelectVariables(Composite parent) {
        final Button button = new Button(parent, 32);
        button.setText("Use only selected variables for data processing.");
        button.setToolTipText("Selected Variables");
        button.setSelection(this.preprocessingSettings.isModifyOnlySelectedVariable());
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreprocessingSettingsUI.this.preprocessingSettings.setModifyOnlySelectedVariable(button.getSelection());
            }
        });
        return button;
    }

    private Canvas createCanvas(Composite parent) {
        final Canvas canvas = new Canvas(parent, 2048);
        canvas.setToolTipText("Formula");
        canvas.setBackground(Colors.WHITE);
        canvas.setData(KEY_IMAGE, (Object)Activator.getDefault().getImage("ICON_DEVIATION"));
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        canvas.setLayoutData((Object)gridData);
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Object object = canvas.getData(PreprocessingSettingsUI.KEY_IMAGE);
                if (object instanceof Image) {
                    Image image = (Image)object;
                    Rectangle src = image.getBounds();
                    Rectangle dest = canvas.getBounds();
                    int x = (int)((float)dest.width / 2.0f - (float)src.width / 2.0f);
                    int y = (int)((float)dest.height / 2.0f - (float)src.height / 2.0f);
                    e.gc.drawImage(image, x, y);
                }
            }
        });
        return canvas;
    }

    private Object[] createScaleElements(int centeringType) {
        return new Object[]{"--", new ScalingAuto(centeringType), new ScalingLevel(centeringType), new ScalingPareto(centeringType), new ScalingRange(centeringType), new ScalingVast(centeringType)};
    }

    private void updateWidgets() {
        if (this.preprocessingSettings != null) {
            this.selectComboItem(this.comboViewerNormalize, this.normalizeInput, (IPreprocessing)this.preprocessingSettings.getNormalization());
            this.selectComboItem(this.comboViewerReplacer, this.replacerInput, (IPreprocessing)this.preprocessingSettings.getReplacer());
            this.selectComboItem(this.comboViewerTransformation, this.transformationInput, (IPreprocessing)this.preprocessingSettings.getTransformation());
            ICentering centering = this.preprocessingSettings.getCentering();
            if (centering != null) {
                switch (centering.getCenteringType()) {
                    case 1: {
                        this.comboViewerCentering.getCombo().select(1);
                        this.comboViewerScaling.setInput((Object)this.scalingInputMean);
                        this.comboViewerScaling.getCombo().setEnabled(true);
                        this.selectComboItem(this.comboViewerScaling, this.scalingInputMean, (IPreprocessing)centering);
                        break;
                    }
                    case 2: {
                        this.comboViewerCentering.getCombo().select(2);
                        this.comboViewerScaling.setInput((Object)this.scalingInputMedian);
                        this.comboViewerScaling.getCombo().setEnabled(true);
                        this.selectComboItem(this.comboViewerScaling, this.scalingInputMedian, (IPreprocessing)centering);
                        break;
                    }
                    default: {
                        this.comboViewerCentering.getCombo().select(0);
                        this.comboViewerScaling.setInput((Object)this.scaleInputEmpty);
                        this.comboViewerScaling.getCombo().select(0);
                        this.comboViewerScaling.getCombo().setEnabled(false);
                    }
                }
            }
            this.checkBoxRemove.setSelection(this.preprocessingSettings.isRemoveUselessVariables());
            this.checkBoxSelect.setSelection(this.preprocessingSettings.isModifyOnlySelectedVariable());
        }
    }

    private void selectComboItem(ComboViewer comboViewer, Object[] input, IPreprocessing selectedPreprocessing) {
        Combo combo = comboViewer.getCombo();
        combo.select(0);
        if (selectedPreprocessing != null) {
            int i = 0;
            while (i < input.length) {
                IPreprocessing preprocessing;
                Object object = input[i];
                if (object instanceof IPreprocessing && (preprocessing = (IPreprocessing)object).getName().equals(selectedPreprocessing.getName())) {
                    combo.select(i);
                    return;
                }
                ++i;
            }
        }
    }

    private void updateFormulaDescription(ComboViewer comboViewer) {
        String text = "--";
        Image image = null;
        Object object = comboViewer.getStructuredSelection().getFirstElement();
        if (object instanceof IPreprocessing) {
            IPreprocessing preprocessing = (IPreprocessing)object;
            text = preprocessing.getDescription();
        }
        if (comboViewer == this.comboViewerNormalize) {
            if (!(object instanceof Normalization1Norm) && !(object instanceof Normalization2Norm)) {
                boolean cfr_ignored_0 = object instanceof NormalizationInfNorm;
            }
        } else if (comboViewer == this.comboViewerReplacer) {
            if (!(object instanceof MeanValuesReplacer) && !(object instanceof MedianValuesReplacer)) {
                boolean cfr_ignored_1 = object instanceof SmallValuesReplacer;
            }
        } else if (comboViewer == this.comboViewerTransformation) {
            if (object instanceof TransformationLOG10) {
                image = Activator.getDefault().getImage("ICON_NORM_TRANS_LOG");
            } else if (object instanceof TransformationPower) {
                image = Activator.getDefault().getImage("ICON_NORM_TRANS_POWER");
            }
        } else if (comboViewer == this.comboViewerCentering) {
            if (object instanceof CenteringMean) {
                image = Activator.getDefault().getImage("ICON_CENTER_MEAN");
            } else if (object instanceof CenteringMedian) {
                image = Activator.getDefault().getImage("ICON_CENTER_MEDIAN");
            }
        } else if (comboViewer == this.comboViewerScaling) {
            if (object instanceof ScalingAuto) {
                image = Activator.getDefault().getImage("ICON_NORM_SCALE_AUTO");
            } else if (object instanceof ScalingLevel) {
                image = Activator.getDefault().getImage("ICON_NORM_SCALE_LEVEL");
            } else if (object instanceof ScalingPareto) {
                image = Activator.getDefault().getImage("ICON_NORM_SCALE_PARETO");
            } else if (object instanceof ScalingRange) {
                image = Activator.getDefault().getImage("ICON_NORM_SCALE_RANGE");
            } else if (object instanceof ScalingVast) {
                image = Activator.getDefault().getImage("ICON_NORM_SCALE_VAST");
            }
        }
        this.labelFormula.setText(text);
        this.canvasFormula.setData(KEY_IMAGE, image);
        this.canvasFormula.redraw();
    }
}

