/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.swt;

import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.FilterSettings;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.IFilterSettings;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.support.FiltersTable;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class FilterSettingsUI
extends Composite {
    private IFilterSettings filterSettings = new FilterSettings();
    private FiltersTable filtersTable;

    public FilterSettingsUI(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void setInput(IFilterSettings filterSettings) {
        this.filterSettings = filterSettings;
        this.updateWidgets();
    }

    public IFilterSettings getFilterSettings() {
        return this.filterSettings;
    }

    private void createControl() {
        this.setLayout((Layout)new GridLayout(1, true));
        this.filtersTable = this.createFiltersTable(this);
        this.createToolbarBottom(this);
    }

    private void updateWidgets() {
        this.filtersTable.setInput(this.filterSettings);
    }

    private FiltersTable createFiltersTable(Composite parent) {
        FiltersTable filtersTable = new FiltersTable(parent, 0);
        filtersTable.setLayoutData(new GridData(1808));
        filtersTable.setInput(this.filterSettings);
        return filtersTable;
    }

    private void createToolbarBottom(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(5, false));
        this.createButtonMoveUp(composite);
        this.createButtonMoveDown(composite);
        this.createButtonAdd(composite);
        this.createButtonRemove(composite);
        this.createButtonRemoveAll(composite);
    }

    private Button createButtonMoveUp(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Move the selected filter up.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/arrow_up_2.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterSettingsUI.this.filtersTable.moveSelectedUp();
            }
        });
        return button;
    }

    private Button createButtonMoveDown(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Move the selected filter down.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/arrow_down_2.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterSettingsUI.this.filtersTable.moveSelectedDown();
            }
        });
        return button;
    }

    private Button createButtonAdd(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Add a new filter.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/add.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterSettingsUI.this.filtersTable.createNewFilter();
            }
        });
        return button;
    }

    private Button createButtonRemove(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Remove the selected filter.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/delete.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterSettingsUI.this.filtersTable.removeSelected();
            }
        });
        return button;
    }

    private Button createButtonRemoveAll(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Remove all filter.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/delete_all.png", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterSettingsUI.this.filtersTable.removeAll();
            }
        });
        return button;
    }
}

