/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.runnable;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.ProcessorPCA;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.exception.MathIllegalArgumentException;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.EvaluationPCA;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IResultsPCA;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.ISamplesPCA;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.ResultsPCA;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.statistics.ISample;
import org.eclipse.chemclipse.model.statistics.IVariable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class CalculationExecutor
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(CalculationExecutor.class);
    private ISamplesPCA<? extends IVariable, ? extends ISample> samples = null;
    private EvaluationPCA evaluationPCA = null;

    public CalculationExecutor(ISamplesPCA<? extends IVariable, ? extends ISample> samples) {
        this.samples = samples;
    }

    public EvaluationPCA getEvaluationPCA() {
        return this.evaluationPCA;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.samples != null) {
            try {
                ProcessorPCA processorPCA = new ProcessorPCA();
                ResultsPCA results = processorPCA.process(this.samples, monitor);
                this.evaluationPCA = new EvaluationPCA(this.samples, (IResultsPCA)results);
            }
            catch (MathIllegalArgumentException e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }
}

