/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.provider;

import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.Feature;
import org.eclipse.chemclipse.model.statistics.IVariable;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class FeatureListFilter
extends ViewerFilter {
    private String searchText;
    private boolean caseSensitive;

    public void setSearchText(String searchText, boolean caseSensitive) {
        this.searchText = searchText;
        this.caseSensitive = caseSensitive;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.searchText == null || this.searchText.equals("")) {
            return true;
        }
        if (element instanceof Feature) {
            String description;
            Feature feature = (Feature)element;
            IVariable variable = feature.getVariable();
            String value = variable.getValue();
            String classification = variable.getClassification() == null ? "" : variable.getClassification();
            String string = description = variable.getDescription() == null ? "" : variable.getDescription();
            if (!this.caseSensitive) {
                this.searchText = this.searchText.toLowerCase();
                value = value.toLowerCase();
                classification = classification.toLowerCase();
                description = description.toLowerCase();
            }
            if (value.contains(this.searchText)) {
                return true;
            }
            if (classification.contains(this.searchText)) {
                return true;
            }
            if (description.contains(this.searchText)) {
                return true;
            }
        }
        return false;
    }
}

