/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.chart3d;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Sphere;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IResultPCA;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IResultsPCA;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.chart3d.ColorSupportFX;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.chart3d.ScorePlot3DSettings;
import org.eclipse.chemclipse.support.text.ValueFormat;

public class ScorePlot3DScatter {
    private static final NumberFormat FORMAT = ValueFormat.getNumberFormatEnglish();
    private static EventType<UpdateSelectionEvent> SELECTION_UPDATE = new EventType("SELECTION_UPDATE");
    private final List<IResultPCA> pcaResultList = new ArrayList<IResultPCA>();
    private final Group mainGroup = new Group();
    private double radius;
    private ScorePlot3DSettings settings;

    public ScorePlot3DScatter(ScorePlot3DSettings settings) {
        this.settings = settings;
        this.radius = 15.0;
        this.pcaResultList.clear();
        this.update();
    }

    public ScorePlot3DScatter(ScorePlot3DSettings settings, IResultsPCA resultsPCA) {
        this(settings);
        this.pcaResultList.clear();
        if (resultsPCA != null) {
            this.pcaResultList.addAll(resultsPCA.getPcaResultList());
        }
        this.update();
    }

    public Group getScarter() {
        return this.mainGroup;
    }

    public void updateSelection() {
        for (Node node : this.mainGroup.getChildren()) {
            node.fireEvent((Event)new UpdateSelectionEvent());
        }
    }

    private void update() {
        double sX = this.settings.getScaleX();
        double sY = this.settings.getScaleY();
        double sZ = this.settings.getScaleZ();
        double shiftX = this.settings.getShiftX() * sX;
        double shiftY = this.settings.getShiftY() * sY;
        double shiftZ = this.settings.getShiftZ() * sZ;
        for (IResultPCA resultPCA : this.pcaResultList) {
            String labelZ;
            String labelY;
            Map<String, Color> colorMap = ColorSupportFX.getGroupNameColorMap(this.pcaResultList);
            String name = resultPCA.getName();
            String groupName = resultPCA.getGroupName();
            Sphere sphere = new Sphere();
            double pcX = resultPCA.getScoreVector()[this.settings.getPcX()];
            double pcY = resultPCA.getScoreVector()[this.settings.getPcY()];
            double pcZ = resultPCA.getScoreVector()[this.settings.getPcZ()];
            sphere.setTranslateX(pcX * sX + shiftX);
            sphere.setTranslateY(pcY * sY + shiftY);
            sphere.setTranslateZ(pcZ * sZ + shiftZ);
            sphere.setRadius(this.radius);
            PhongMaterial material = new PhongMaterial();
            Color color = colorMap.get(groupName);
            material.setDiffuseColor(color);
            material.setSpecularColor(color);
            sphere.setMaterial((Material)material);
            StringBuilder sb = new StringBuilder();
            sb.append(name);
            sb.append('\n');
            String labelX = this.settings.getLabelAxisX();
            if (!labelX.isEmpty()) {
                sb.append(labelX);
                sb.append(" = ");
                sb.append(FORMAT.format(pcX));
                sb.append("; ");
            }
            if (!(labelY = this.settings.getLabelAxisY()).isEmpty()) {
                sb.append(labelY);
                sb.append(" = ");
                sb.append(FORMAT.format(pcY));
                sb.append("; ");
            }
            if (!(labelZ = this.settings.getLabelAxisZ()).isEmpty()) {
                sb.append(labelZ);
                sb.append(" = ");
                sb.append(FORMAT.format(pcZ));
                sb.append("; ");
            }
            Tooltip t = new Tooltip(sb.toString());
            Tooltip.install((Node)sphere, (Tooltip)t);
            sphere.setOnMouseEntered(e -> {
                Color darkerColor = ((Color)colorMap.get(groupName)).darker();
                material.setDiffuseColor(darkerColor);
                material.setSpecularColor(darkerColor);
            });
            sphere.setOnMouseExited(e -> {
                material.setDiffuseColor((Color)colorMap.get(groupName));
                material.setSpecularColor((Color)colorMap.get(groupName));
                t.hide();
            });
            sphere.setOnMouseClicked(e -> {
                if (e.getButton().equals((Object)MouseButton.PRIMARY) && e.getClickCount() == 2 && e.isControlDown()) {
                    resultPCA.getSample().setSelected(!resultPCA.getSample().isSelected());
                }
            });
            sphere.addEventFilter(SELECTION_UPDATE, event -> {
                material.setDiffuseColor((Color)colorMap.get(groupName));
                material.setSpecularColor((Color)colorMap.get(groupName));
                sphere.setVisible(resultPCA.isDisplayed());
            });
            this.mainGroup.getChildren().addAll((Object[])new Node[]{sphere});
        }
        this.updateSelection();
    }

    private class UpdateSelectionEvent
    extends Event {
        private static final long serialVersionUID = -2717902232561677870L;

        public UpdateSelectionEvent() {
            super(SELECTION_UPDATE);
        }
    }
}

