/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.csv.io.heatmap;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.converter.io.AbstractChromatogramWriter;
import org.eclipse.chemclipse.model.comparator.PeakRetentionTimeComparator;
import org.eclipse.chemclipse.model.comparator.TargetExtendedComparator;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.msd.converter.io.IChromatogramMSDWriter;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.support.comparator.SortOrder;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramWriter
extends AbstractChromatogramWriter
implements IChromatogramMSDWriter {
    private PeakRetentionTimeComparator chromatogramPeakComparator = new PeakRetentionTimeComparator(SortOrder.DESC);
    private TargetExtendedComparator targetExtendedComparator = new TargetExtendedComparator(SortOrder.DESC);
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish();

    public void writeChromatogram(File file, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        FileWriter writer = new FileWriter(file);
        CSVPrinter csvFilePrinter = new CSVPrinter((Appendable)writer, CSVFormat.EXCEL);
        ArrayList<String> headerValues = new ArrayList<String>();
        headerValues.add("mzLo");
        headerValues.add("mzHi");
        headerValues.add("rtLo");
        headerValues.add("rtHi");
        headerValues.add("color");
        headerValues.add("opacity");
        headerValues.add("identification");
        headerValues.add("matchFactor");
        headerValues.add("reverseMatchFactor");
        csvFilePrinter.printRecord(headerValues);
        try {
            try {
                ArrayList chromatogramPeaks = new ArrayList(chromatogram.getPeaks());
                Collections.sort(chromatogramPeaks, this.chromatogramPeakComparator);
                for (IChromatogramPeakMSD chromatogramPeak : chromatogramPeaks) {
                    IPeakMassSpectrum peakMassSpectrum = chromatogramPeak.getExtractedMassSpectrum();
                    ArrayList peakTargets = new ArrayList(chromatogramPeak.getTargets());
                    Collections.sort(peakTargets, this.targetExtendedComparator);
                    ArrayList<String> targetValues = new ArrayList<String>();
                    targetValues.add(this.decimalFormat.format(peakMassSpectrum.getLowestIon().getIon()));
                    targetValues.add(this.decimalFormat.format(peakMassSpectrum.getHighestIon().getIon()));
                    targetValues.add(this.decimalFormat.format((double)chromatogramPeak.getPeakModel().getStartRetentionTime() / 60000.0));
                    targetValues.add(this.decimalFormat.format((double)chromatogramPeak.getPeakModel().getStopRetentionTime() / 60000.0));
                    targetValues.add("#A70000");
                    targetValues.add("0.75");
                    if (peakTargets.size() > 0) {
                        IIdentificationTarget peakTarget = (IIdentificationTarget)peakTargets.get(0);
                        targetValues.add(peakTarget.getLibraryInformation().getName());
                        targetValues.add(this.decimalFormat.format(peakTarget.getComparisonResult().getMatchFactor()));
                        targetValues.add(this.decimalFormat.format(peakTarget.getComparisonResult().getReverseMatchFactor()));
                    } else {
                        targetValues.add("");
                        targetValues.add("");
                        targetValues.add("");
                    }
                    csvFilePrinter.printRecord(targetValues);
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        finally {
            if (csvFilePrinter != null) {
                csvFilePrinter.close();
            }
        }
    }
}

