/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.csd.identifier.peak;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.csd.identifier.peak.IPeakIdentifierCSD;
import org.eclipse.chemclipse.chromatogram.csd.identifier.peak.IPeakIdentifierSupportCSD;
import org.eclipse.chemclipse.chromatogram.csd.identifier.peak.PeakIdentifierSupplierCSD;
import org.eclipse.chemclipse.chromatogram.csd.identifier.peak.PeakIdentifierSupportCSD;
import org.eclipse.chemclipse.chromatogram.csd.identifier.settings.IPeakIdentifierSettingsCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IPeakCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class PeakIdentifierCSD {
    private static final Logger logger = Logger.getLogger(PeakIdentifierCSD.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.chromatogram.csd.identifier.peakIdentifier";
    private static final String NO_IDENTIFIER_AVAILABLE = "There is no suitable peak identifier available";

    private static IConfigurationElement getConfigurationElement(String filterId) {
        IConfigurationElement[] elements;
        if ("".equals(filterId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute("id").equals(filterId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private static <T> IProcessingInfo<T> getNoIdentifierAvailableProcessingInfo() {
        ProcessingInfo processingInfo = new ProcessingInfo();
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Peak Identifier", NO_IDENTIFIER_AVAILABLE);
        processingInfo.addMessage((IProcessingMessage)processingMessage);
        return processingInfo;
    }

    private static <T> IPeakIdentifierCSD<T> getPeakIdentifier(String identifierId) {
        IConfigurationElement element = PeakIdentifierCSD.getConfigurationElement(identifierId);
        IPeakIdentifierCSD instance = null;
        if (element != null) {
            try {
                instance = (IPeakIdentifierCSD)element.createExecutableExtension("identifier");
            }
            catch (CoreException e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return instance;
    }

    public static IPeakIdentifierSupportCSD getPeakIdentifierSupport() {
        IConfigurationElement[] extensions;
        PeakIdentifierSupportCSD identifierSupport = new PeakIdentifierSupportCSD();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            PeakIdentifierSupplierCSD supplier = new PeakIdentifierSupplierCSD();
            supplier.setId(element.getAttribute("id"));
            supplier.setDescription(element.getAttribute("description"));
            supplier.setIdentifierName(element.getAttribute("identifierName"));
            if (element.getAttribute("identifierSettings") != null) {
                try {
                    IPeakIdentifierSettingsCSD instance = (IPeakIdentifierSettingsCSD)element.createExecutableExtension("identifierSettings");
                    supplier.setIdentifierSettingsClass(instance.getClass());
                }
                catch (CoreException e) {
                    logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    supplier.setIdentifierSettingsClass(null);
                }
            }
            identifierSupport.add(supplier);
            ++n2;
        }
        return identifierSupport;
    }

    public static <T> IProcessingInfo<T> identify(IChromatogramPeakCSD peak, IPeakIdentifierSettingsCSD identifierSettings, String identifierId, IProgressMonitor monitor) {
        IPeakIdentifierCSD<T> peakIdentifier = PeakIdentifierCSD.getPeakIdentifier(identifierId);
        IProcessingInfo<T> processingInfo = peakIdentifier != null ? peakIdentifier.identify((IPeakCSD)peak, identifierSettings, monitor) : PeakIdentifierCSD.getNoIdentifierAvailableProcessingInfo();
        return processingInfo;
    }

    public static <T> IProcessingInfo<T> identify(IPeakCSD peak, String identifierId, IProgressMonitor monitor) {
        IPeakIdentifierCSD<T> peakIdentifier = PeakIdentifierCSD.getPeakIdentifier(identifierId);
        IProcessingInfo<T> processingInfo = peakIdentifier != null ? peakIdentifier.identify(peak, monitor) : PeakIdentifierCSD.getNoIdentifierAvailableProcessingInfo();
        return processingInfo;
    }

    public static <T> IProcessingInfo<T> identify(List<? extends IPeakCSD> peaks, IPeakIdentifierSettingsCSD identifierSettings, String identifierId, IProgressMonitor monitor) {
        IPeakIdentifierCSD<T> peakIdentifier = PeakIdentifierCSD.getPeakIdentifier(identifierId);
        IProcessingInfo<T> processingInfo = peakIdentifier != null ? peakIdentifier.identify(peaks, identifierSettings, monitor) : PeakIdentifierCSD.getNoIdentifierAvailableProcessingInfo();
        return processingInfo;
    }

    public static <T> IProcessingInfo<T> identify(List<? extends IPeakCSD> peaks, String identifierId, IProgressMonitor monitor) {
        IPeakIdentifierCSD<T> peakIdentifier = PeakIdentifierCSD.getPeakIdentifier(identifierId);
        IProcessingInfo<T> processingInfo = peakIdentifier != null ? peakIdentifier.identify(peaks, monitor) : PeakIdentifierCSD.getNoIdentifierAvailableProcessingInfo();
        return processingInfo;
    }

    public static <T> IProcessingInfo<T> identify(IChromatogramSelectionCSD chromatogramSelectionCSD, String identifierId, IProgressMonitor monitor) {
        IPeakIdentifierCSD<T> peakIdentifier = PeakIdentifierCSD.getPeakIdentifier(identifierId);
        IProcessingInfo<T> processingInfo = peakIdentifier != null ? peakIdentifier.identify(chromatogramSelectionCSD, monitor) : PeakIdentifierCSD.getNoIdentifierAvailableProcessingInfo();
        return processingInfo;
    }

    public static <T> IProcessingInfo<T> identify(IChromatogramSelectionCSD chromatogramSelectionCSD, IPeakIdentifierSettingsCSD peakIdentifierSettingsCSD, String identifierId, IProgressMonitor monitor) {
        IPeakIdentifierCSD<T> peakIdentifier = PeakIdentifierCSD.getPeakIdentifier(identifierId);
        IProcessingInfo<T> processingInfo = peakIdentifier != null ? peakIdentifier.identify(chromatogramSelectionCSD, peakIdentifierSettingsCSD, monitor) : PeakIdentifierCSD.getNoIdentifierAvailableProcessingInfo();
        return processingInfo;
    }

    private PeakIdentifierCSD() {
    }
}

