/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.rcp.app.ui.internal.support;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.rcp.app.cli.ICommandLineProcessor;
import org.eclipse.chemclipse.rcp.app.ui.ApplicationWorkbenchAdvisor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;

public class ApplicationSupportCLI {
    private static final Logger logger = Logger.getLogger(ApplicationSupportCLI.class);
    private IExtensionRegistry registry = Platform.getExtensionRegistry();
    private IConfigurationElement[] elements = this.registry.getConfigurationElementsFor("org.eclipse.chemclipse.rcp.app.ui.commandLineProcessor");
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.rcp.app.ui.commandLineProcessor";
    private static final String OPTION_HELP = "help";
    private static final String OPTION_HELP_DESCRIPTION = "Shows the help.";
    private static final String OPTION_COMMAND_LINE = "cli";
    private static final String OPTION_COMMAND_LINE_DESCRIPTION = "Run the application in command line mode.";
    private static final String OPTION_ECLIPSE_COMMAND_LINE_DESCRIPTION = "See eclipse command line description.";
    private static final String OPTION_ATTRIBUTE_NAME = "option";
    private static final String OPTION_ATTRIBUTE_HAS_ARGUMENTS = "hasArguments";
    private static final String OPTION_ATTRIBUTE_DESCRIPTION = "description";
    private static final String EXECUTABLE_EXTENSION_NAME = "processor";

    public ApplicationSupportCLI() {
        logger.info((Object)"Command Line Processor Options");
        IConfigurationElement[] iConfigurationElementArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            logger.info((Object)("Option: -" + element.getAttribute(OPTION_ATTRIBUTE_NAME)));
            ++n2;
        }
    }

    public Object start(IApplicationContext context) {
        Options options = this.getDefaultOptions();
        this.addExtensionPointOptions(this.elements, options);
        BasicParser commandLineParser = new BasicParser();
        try {
            String[] commandLineArgs = this.getCommandLineArgs();
            CommandLine commandLine = commandLineParser.parse(options, commandLineArgs, false);
            if (commandLine.hasOption(OPTION_HELP) || commandLine.hasOption(OPTION_COMMAND_LINE)) {
                return this.startCommandLineContext(commandLine, options);
            }
            return this.startGraphicalContext();
        }
        catch (ParseException e) {
            System.out.println((Object)e);
            return IApplication.EXIT_OK;
        }
    }

    private Object startCommandLineContext(CommandLine commandLine, Options options) {
        if (commandLine.hasOption(OPTION_HELP)) {
            return this.printOptionsHelp(options);
        }
        if (commandLine.hasOption(OPTION_COMMAND_LINE)) {
            return this.executeCommandLineCommands(this.elements, commandLine);
        }
        return IApplication.EXIT_OK;
    }

    private Object startGraphicalContext() {
        Display display = PlatformUI.createDisplay();
        try {
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new ApplicationWorkbenchAdvisor());
            if (returnCode == 1) {
                Integer n = IApplication.EXIT_RESTART;
                return n;
            }
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        finally {
            display.dispose();
        }
    }

    private Object printOptionsHelp(Options options) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("How to use the command line options", options);
        return IApplication.EXIT_OK;
    }

    private Object executeCommandLineCommands(IConfigurationElement[] elements, CommandLine commandLine) {
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String opt = element.getAttribute(OPTION_ATTRIBUTE_NAME);
            if (commandLine.hasOption(opt)) {
                try {
                    String[] args = commandLine.getOptionValues(opt);
                    ICommandLineProcessor commandLineProcessor = (ICommandLineProcessor)element.createExecutableExtension(EXECUTABLE_EXTENSION_NAME);
                    commandLineProcessor.process(args);
                }
                catch (CoreException e) {
                    System.out.println((Object)e);
                }
            }
            ++n2;
        }
        return IApplication.EXIT_OK;
    }

    private Options getDefaultOptions() {
        Options options = new Options();
        this.setCommandLineOptions(options);
        this.setDefaultOptions(options);
        return options;
    }

    private void setCommandLineOptions(Options options) {
        options.addOption(OPTION_HELP, false, OPTION_HELP_DESCRIPTION);
        options.addOption(OPTION_COMMAND_LINE, false, OPTION_COMMAND_LINE_DESCRIPTION);
    }

    private void setDefaultOptions(Options options) {
        Properties properties = System.getProperties();
        String eclipseCommands = (String)properties.get("eclipse.commands");
        Pattern pattern = Pattern.compile("(.*)(-)(.*?)(\r|\n)");
        Matcher matcher = pattern.matcher(eclipseCommands);
        while (matcher.find()) {
            String groupOne = matcher.group(1);
            if (groupOne != null && !groupOne.equals("")) continue;
            options.addOption(matcher.group(3), false, OPTION_ECLIPSE_COMMAND_LINE_DESCRIPTION);
        }
    }

    private String[] getCommandLineArgs() {
        String[] commandLineArgs = Platform.getCommandLineArgs();
        int i = 0;
        while (i < commandLineArgs.length) {
            String commandLineArg = commandLineArgs[i];
            if (commandLineArg != null && commandLineArg.startsWith("--")) {
                String modifiedArg = commandLineArg.replace("--", "");
                commandLineArgs[i] = modifiedArg = modifiedArg.replaceAll("\\.", "_");
            }
            ++i;
        }
        return commandLineArgs;
    }

    private void addExtensionPointOptions(IConfigurationElement[] elements, Options options) {
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String opt = element.getAttribute(OPTION_ATTRIBUTE_NAME);
            boolean hasArguments = Boolean.valueOf(element.getAttribute(OPTION_ATTRIBUTE_HAS_ARGUMENTS));
            String description = element.getAttribute(OPTION_ATTRIBUTE_DESCRIPTION);
            Option option = new Option(opt, hasArguments, description);
            options.addOption(option);
            ++n2;
        }
    }
}

