/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.grid.command;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOffCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOnCommand;
import org.eclipse.nebula.widgets.nattable.resize.MaxCellBoundsHelper;
import org.eclipse.nebula.widgets.nattable.resize.command.AutoResizeRowsCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.MultiRowResizeCommand;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;

public class AutoResizeRowCommandHandler
implements ILayerCommandHandler<AutoResizeRowsCommand> {
    protected final ILayer commandLayer;
    protected final ILayer positionLayer;

    public AutoResizeRowCommandHandler(ILayer commandLayer, ILayer positionLayer) {
        this.commandLayer = commandLayer;
        this.positionLayer = positionLayer;
    }

    public AutoResizeRowCommandHandler(GridLayer gridLayer) {
        this.commandLayer = gridLayer;
        this.positionLayer = gridLayer.getBodyLayer();
    }

    @Override
    public Class<AutoResizeRowsCommand> getCommandClass() {
        return AutoResizeRowsCommand.class;
    }

    @Override
    public boolean doCommand(ILayer targetLayer, AutoResizeRowsCommand command) {
        targetLayer.doCommand(new TurnViewportOffCommand());
        int[] rowPositions = ObjectUtils.asIntArray(command.getRowPositions());
        int[] gridRowPositions = this.convertFromPositionToCommandLayer(rowPositions);
        int[] gridRowHeights = MaxCellBoundsHelper.getPreferredRowHeights(command.getConfigRegistry(), command.getGCFactory(), this.commandLayer, gridRowPositions);
        this.commandLayer.doCommand(new MultiRowResizeCommand(this.commandLayer, gridRowPositions, gridRowHeights));
        targetLayer.doCommand(new TurnViewportOnCommand());
        return true;
    }

    protected int[] convertFromPositionToCommandLayer(int[] rowPositions) {
        int[] commandLayerRowPositions = new int[rowPositions.length];
        int i = 0;
        while (i < rowPositions.length) {
            commandLayerRowPositions[i] = this.commandLayer.underlyingToLocalRowPosition(this.positionLayer, rowPositions[i]);
            ++i;
        }
        return commandLayerRowPositions;
    }
}

