/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.command;

import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.edit.EditController;
import org.eclipse.nebula.widgets.nattable.edit.command.EditSelectionCommand;
import org.eclipse.nebula.widgets.nattable.edit.command.EditUtils;
import org.eclipse.nebula.widgets.nattable.edit.event.InlineCellEditEvent;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.swt.widgets.Composite;

public class EditSelectionCommandHandler
extends AbstractLayerCommandHandler<EditSelectionCommand> {
    private SelectionLayer selectionLayer;

    public EditSelectionCommandHandler(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    @Override
    public Class<EditSelectionCommand> getCommandClass() {
        return EditSelectionCommand.class;
    }

    @Override
    public boolean doCommand(EditSelectionCommand command) {
        Composite parent = command.getParent();
        IConfigRegistry configRegistry = command.getConfigRegistry();
        Character initialValue = command.getCharacter();
        if (EditUtils.allCellsEditable(this.selectionLayer, configRegistry) && EditUtils.isEditorSame(this.selectionLayer, configRegistry) && EditUtils.isConverterSame(this.selectionLayer, configRegistry) && EditUtils.activateLastSelectedCellEditor(this.selectionLayer, configRegistry, command.isByTraversal())) {
            Collection<ILayerCell> selectedCells = EditUtils.getSelectedCellsForEditing(this.selectionLayer);
            if (selectedCells.size() == 1) {
                ILayerCell cell = selectedCells.iterator().next();
                this.selectionLayer.fireLayerEvent(new InlineCellEditEvent(this.selectionLayer, new PositionCoordinate(this.selectionLayer, cell.getColumnPosition(), cell.getRowPosition()), parent, configRegistry, initialValue != null ? initialValue : cell.getDataValue()));
            } else if (selectedCells.size() > 1) {
                Object initialEditValue = initialValue;
                if (initialValue == null && EditUtils.isValueSame(this.selectionLayer)) {
                    ILayerCell cell = selectedCells.iterator().next();
                    initialEditValue = this.selectionLayer.getDataValueByPosition(cell.getColumnPosition(), cell.getRowPosition());
                }
                EditController.editCells(selectedCells, parent, initialEditValue, configRegistry);
            }
        }
        return true;
    }
}

