/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.wsd.converter.io.AbstractChromatogramWSDReader;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.internal.io.AbstractChromatogramReader;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1005;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1006;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1007;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1100;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1300;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1301;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.io.IChromatogramWSDZipReader;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.ReaderHelper;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramReaderWSD
extends AbstractChromatogramWSDReader
implements IChromatogramWSDZipReader {
    public IChromatogramOverview readOverview(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        IChromatogramOverview chromatogramOverview = null;
        ReaderHelper readerHelper = new ReaderHelper();
        String version = readerHelper.getVersion(file);
        IChromatogramWSDZipReader chromatogramReader = this.getChromatogramReader(version);
        if (chromatogramReader != null) {
            try {
                chromatogramOverview = chromatogramReader.readOverview(file, monitor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return chromatogramOverview;
    }

    public IChromatogramWSD read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        IChromatogramWSD chromatogramWSD = null;
        ReaderHelper readerHelper = new ReaderHelper();
        String version = readerHelper.getVersion(file);
        IChromatogramWSDZipReader chromatogramReader = this.getChromatogramReader(version);
        if (chromatogramReader != null) {
            try {
                chromatogramWSD = chromatogramReader.read(file, monitor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return chromatogramWSD;
    }

    @Override
    public IChromatogramWSD read(ZipInputStream zipInputStream, String directoryPrefix, IProgressMonitor monitor) throws IOException {
        return this.readChromatogram(zipInputStream, directoryPrefix, monitor);
    }

    @Override
    public IChromatogramWSD read(ZipFile zipFile, String directoryPrefix, IProgressMonitor monitor) throws IOException {
        return this.readChromatogram(zipFile, directoryPrefix, monitor);
    }

    private IChromatogramWSD readChromatogram(Object object, String directoryPrefix, IProgressMonitor monitor) throws IOException {
        IChromatogramWSDZipReader chromatogramReader = null;
        IChromatogramWSD chromatogramWSD = null;
        ReaderHelper readerHelper = new ReaderHelper();
        String version = readerHelper.getVersion(object, directoryPrefix);
        chromatogramReader = this.getChromatogramReader(version);
        if (chromatogramReader != null) {
            if (object instanceof ZipInputStream) {
                chromatogramWSD = chromatogramReader.read((ZipInputStream)object, directoryPrefix, monitor);
            } else if (object instanceof ZipFile) {
                chromatogramWSD = chromatogramReader.read((ZipFile)object, directoryPrefix, monitor);
            }
        }
        return chromatogramWSD;
    }

    private IChromatogramWSDZipReader getChromatogramReader(String version) {
        AbstractChromatogramReader chromatogramReader = null;
        if (version.equals("1.0.0.5")) {
            chromatogramReader = new ChromatogramReader_1005();
        } else if (version.equals("1.0.0.6")) {
            chromatogramReader = new ChromatogramReader_1006();
        } else if (version.equals("1.0.0.7")) {
            chromatogramReader = new ChromatogramReader_1007();
        } else if (version.equals("1.1.0.0")) {
            chromatogramReader = new ChromatogramReader_1100();
        } else if (version.equals("1.3.0.0")) {
            chromatogramReader = new ChromatogramReader_1300();
        } else if (version.equals("1.3.0.1")) {
            chromatogramReader = new ChromatogramReader_1301();
        }
        return chromatogramReader;
    }
}

