/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.internal.io;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.converter.io.AbstractChromatogramWriter;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.core.IMethod;
import org.eclipse.chemclipse.model.core.RetentionIndexType;
import org.eclipse.chemclipse.support.history.IEditHistory;
import org.eclipse.chemclipse.support.history.IEditInformation;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.io.IChromatogramWSDZipWriter;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.IScanSignalWSD;
import org.eclipse.chemclipse.wsd.model.core.IScanWSD;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.preferences.PreferenceSupplier;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramWriter_1007
extends AbstractChromatogramWriter
implements IChromatogramWSDZipWriter {
    public void writeChromatogram(File file, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
        zipOutputStream.setLevel(PreferenceSupplier.getChromatogramCompressionLevel());
        zipOutputStream.setMethod(8);
        this.writeChromatogram(zipOutputStream, "", chromatogram, monitor);
        zipOutputStream.flush();
        zipOutputStream.close();
    }

    @Override
    public void writeChromatogram(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws IOException {
        this.writeVersion(zipOutputStream, directoryPrefix, monitor);
        this.writeOverviewFolder(zipOutputStream, directoryPrefix, chromatogram, monitor);
        this.writeChromatogramFolder(zipOutputStream, directoryPrefix, chromatogram, monitor);
    }

    private void writeVersion(ZipOutputStream zipOutputStream, String directoryPrefix, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "VERSION");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        String version = "1.0.0.7";
        dataOutputStream.writeInt(version.length());
        dataOutputStream.writeChars(version);
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeOverviewFolder(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "WSD/OVERVIEW/");
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.closeEntry();
        zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "WSD/OVERVIEW/TIC");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        int scans = chromatogram.getNumberOfScans();
        dataOutputStream.writeInt(scans);
        int scan = 1;
        while (scan <= scans) {
            IScanWSD scanWSD = chromatogram.getSupplierScan(scan);
            int scanSignalTotal = scanWSD.getScanSignals().size();
            dataOutputStream.writeInt(scanSignalTotal);
            int signal = 0;
            while (signal < scanSignalTotal) {
                IScanSignalWSD scanSignal = scanWSD.getScanSignal(signal);
                int wavelength = (int)scanSignal.getWavelength();
                float abundance = scanSignal.getAbundance();
                dataOutputStream.writeInt(wavelength);
                dataOutputStream.writeFloat(abundance);
                ++signal;
            }
            dataOutputStream.writeInt(scanWSD.getRetentionTime());
            dataOutputStream.writeFloat(scanWSD.getRetentionIndex());
            dataOutputStream.writeFloat(scanWSD.getTotalSignal());
            dataOutputStream.writeInt(scanWSD.getTimeSegmentId());
            dataOutputStream.writeInt(scanWSD.getCycleNumber());
            ++scan;
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramFolder(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "WSD/CHROMATOGRAM/");
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.closeEntry();
        this.writeChromatogramMethod(zipOutputStream, directoryPrefix, chromatogram, monitor);
        this.writeChromatogramScans(zipOutputStream, directoryPrefix, chromatogram, monitor);
        this.writeChromatogramBaseline(zipOutputStream, directoryPrefix, chromatogram, monitor);
        this.writeChromatogramHistory(zipOutputStream, directoryPrefix, chromatogram, monitor);
        this.writeChromatogramMiscellaneous(zipOutputStream, directoryPrefix, chromatogram, monitor);
    }

    private void writeChromatogramMethod(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "WSD/CHROMATOGRAM/SYSTEM_SETTINGS");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        IMethod method = chromatogram.getMethod();
        this.writeString(dataOutputStream, method.getInstrumentName());
        this.writeString(dataOutputStream, method.getIonSource());
        dataOutputStream.writeDouble(method.getSamplingRate());
        dataOutputStream.writeInt(method.getSolventDelay());
        dataOutputStream.writeDouble(method.getSourceHeater());
        this.writeString(dataOutputStream, method.getStopMode());
        dataOutputStream.writeInt(method.getStopTime());
        dataOutputStream.writeInt(method.getTimeFilterPeakWidth());
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramScans(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "WSD/CHROMATOGRAM/SCANS");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        int scans = chromatogram.getNumberOfScans();
        dataOutputStream.writeInt(scans);
        int scan = 1;
        while (scan <= scans) {
            IScanWSD scanWSD = chromatogram.getSupplierScan(scan);
            int scanSignalTotal = scanWSD.getScanSignals().size();
            dataOutputStream.writeInt(scanSignalTotal);
            int signal = 0;
            while (signal < scanSignalTotal) {
                IScanSignalWSD scanSignal = scanWSD.getScanSignal(signal);
                int wavelength = (int)scanSignal.getWavelength();
                float abundance = scanSignal.getAbundance();
                dataOutputStream.writeInt(wavelength);
                dataOutputStream.writeFloat(abundance);
                ++signal;
            }
            dataOutputStream.writeInt(scanWSD.getRetentionTime());
            dataOutputStream.writeInt(scanWSD.getRetentionTimeColumn1());
            dataOutputStream.writeInt(scanWSD.getRetentionTimeColumn2());
            dataOutputStream.writeFloat(scanWSD.getRetentionIndex());
            dataOutputStream.writeBoolean(scanWSD.hasAdditionalRetentionIndices());
            if (scanWSD.hasAdditionalRetentionIndices()) {
                Map retentionIndicesTyped = scanWSD.getRetentionIndicesTyped();
                dataOutputStream.writeInt(retentionIndicesTyped.size());
                for (Map.Entry retentionIndexTyped : retentionIndicesTyped.entrySet()) {
                    this.writeString(dataOutputStream, ((RetentionIndexType)retentionIndexTyped.getKey()).toString());
                    dataOutputStream.writeFloat(((Float)retentionIndexTyped.getValue()).floatValue());
                }
            }
            dataOutputStream.writeFloat(scanWSD.getTotalSignal());
            dataOutputStream.writeInt(scanWSD.getTimeSegmentId());
            dataOutputStream.writeInt(scanWSD.getCycleNumber());
            ++scan;
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramBaseline(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "WSD/CHROMATOGRAM/BASELINE");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        int scans = chromatogram.getNumberOfScans();
        dataOutputStream.writeInt(scans);
        IBaselineModel baselineModel = chromatogram.getBaselineModel();
        int scan = 1;
        while (scan <= scans) {
            int retentionTime = chromatogram.getSupplierScan(scan).getRetentionTime();
            float backgroundAbundance = baselineModel.getBackgroundAbundance(retentionTime);
            dataOutputStream.writeInt(retentionTime);
            dataOutputStream.writeFloat(backgroundAbundance);
            ++scan;
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramHistory(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "WSD/CHROMATOGRAM/HISTORY");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        IEditHistory editHistory = chromatogram.getEditHistory();
        dataOutputStream.writeInt(editHistory.size());
        for (IEditInformation editInformation : editHistory) {
            dataOutputStream.writeLong(editInformation.getDate().getTime());
            this.writeString(dataOutputStream, editInformation.getDescription());
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramMiscellaneous(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "WSD/CHROMATOGRAM/MISC");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        dataOutputStream.writeLong(chromatogram.getDate().getTime());
        this.writeString(dataOutputStream, chromatogram.getMiscInfo());
        this.writeString(dataOutputStream, chromatogram.getMiscInfoSeparated());
        this.writeString(dataOutputStream, chromatogram.getDataName());
        this.writeString(dataOutputStream, chromatogram.getOperator());
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeString(DataOutputStream dataOutputStream, String value) throws IOException {
        dataOutputStream.writeInt(value.length());
        dataOutputStream.writeChars(value);
    }
}

