/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.zip.ZipFile;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.RetentionIndexType;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.model.exceptions.ReferenceMustNotBeNullException;
import org.eclipse.chemclipse.model.identifier.ComparisonResult;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.identifier.LibraryInformation;
import org.eclipse.chemclipse.model.implementation.IdentificationTarget;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.AbstractZipReader;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.io.IReaderProxy;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.model.chromatogram.IVendorIon;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.model.chromatogram.IVendorScan;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.model.chromatogram.IVendorScanProxy;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.model.chromatogram.VendorIon;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IIonTransition;
import org.eclipse.chemclipse.msd.model.core.IIonTransitionSettings;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.exceptions.IonTransitionIsNullException;
import org.eclipse.chemclipse.msd.model.implementation.ScanMSD;

public class ReaderProxy_1301
extends AbstractZipReader
implements IReaderProxy {
    private static final Logger logger = Logger.getLogger(ReaderProxy_1301.class);

    @Override
    public void readMassSpectrum(File file, int offset, IVendorScanProxy massSpectrum, IIonTransitionSettings ionTransitionSettings) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            DataInputStream dataInputStream = this.getDataInputStream(zipFile, "MSD/CHROMATOGRAM/SCANS");
            dataInputStream.skipBytes(offset);
            this.readMassSpectrum(massSpectrum, dataInputStream, ionTransitionSettings);
            dataInputStream.close();
        }
    }

    @Override
    public void readMassSpectrum(IVendorScan massSpectrum, DataInputStream dataInputStream, IIonTransitionSettings ionTransitionSettings) throws IOException {
        short massSpectrometer = dataInputStream.readShort();
        short massSpectrumType = dataInputStream.readShort();
        double precursorIon = dataInputStream.readDouble();
        massSpectrum.setMassSpectrometer(massSpectrometer);
        massSpectrum.setMassSpectrumType(massSpectrumType);
        massSpectrum.setPrecursorIon(precursorIon);
        this.readNormalMassSpectrum((IScanMSD)massSpectrum, dataInputStream, ionTransitionSettings);
        boolean readOptimizedMassSpectrum = dataInputStream.readBoolean();
        if (readOptimizedMassSpectrum) {
            ScanMSD optimizedMassSpectrum = new ScanMSD();
            this.readNormalMassSpectrum((IScanMSD)optimizedMassSpectrum, dataInputStream, ionTransitionSettings);
            massSpectrum.setOptimizedMassSpectrum((IScanMSD)optimizedMassSpectrum);
        }
    }

    private void readNormalMassSpectrum(IScanMSD massSpectrum, DataInputStream dataInputStream, IIonTransitionSettings ionTransitionSettings) throws IOException {
        int retentionTime = dataInputStream.readInt();
        int relativeRetentionTime = dataInputStream.readInt();
        int retentionTimeColumn1 = dataInputStream.readInt();
        int retentionTimeColumn2 = dataInputStream.readInt();
        float retentionIndex = dataInputStream.readFloat();
        if (dataInputStream.readBoolean()) {
            int size = dataInputStream.readInt();
            int i = 0;
            while (i < size) {
                RetentionIndexType retentionIndexType = RetentionIndexType.valueOf((String)this.readString(dataInputStream));
                float retentionIndexAdditional = dataInputStream.readFloat();
                massSpectrum.setRetentionIndex(retentionIndexType, retentionIndexAdditional);
                ++i;
            }
        }
        int timeSegmentId = dataInputStream.readInt();
        int cycleNumber = dataInputStream.readInt();
        massSpectrum.setRetentionTime(retentionTime);
        massSpectrum.setRelativeRetentionTime(relativeRetentionTime);
        massSpectrum.setRetentionTimeColumn1(retentionTimeColumn1);
        massSpectrum.setRetentionTimeColumn2(retentionTimeColumn2);
        massSpectrum.setRetentionIndex(retentionIndex);
        massSpectrum.setTimeSegmentId(timeSegmentId);
        massSpectrum.setCycleNumber(cycleNumber);
        int numberOfIons = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfIons) {
            try {
                IVendorIon ion = this.readIon(dataInputStream, ionTransitionSettings);
                massSpectrum.addIon((IIon)ion);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonTransitionIsNullException e) {
                logger.warn((Object)e);
            }
            ++i;
        }
        this.readScanIdentificationTargets(dataInputStream, massSpectrum);
    }

    private IVendorIon readIon(DataInputStream dataInputStream, IIonTransitionSettings ionTransitionSettings) throws IOException, AbundanceLimitExceededException, IonLimitExceededException, IonTransitionIsNullException {
        VendorIon ion;
        double mz = dataInputStream.readDouble();
        float abundance = dataInputStream.readFloat();
        int transition = dataInputStream.readInt();
        if (transition == 0) {
            ion = new VendorIon(mz, abundance);
        } else {
            String compoundName = this.readString(dataInputStream);
            double filter1FirstIon = dataInputStream.readDouble();
            double filter1LastIon = dataInputStream.readDouble();
            double filter3FirstIon = dataInputStream.readDouble();
            double filter3LastIon = dataInputStream.readDouble();
            double collisionEnergy = dataInputStream.readDouble();
            double filter1Resolution = dataInputStream.readDouble();
            double filter3Resolution = dataInputStream.readDouble();
            int transitionGroup = dataInputStream.readInt();
            int dwell = dataInputStream.readInt();
            IIonTransition ionTransition = ionTransitionSettings.getIonTransition(compoundName, filter1FirstIon, filter1LastIon, filter3FirstIon, filter3LastIon, collisionEnergy, filter1Resolution, filter3Resolution, transitionGroup);
            ionTransition.setDwell(dwell);
            ion = new VendorIon(mz, abundance, ionTransition);
        }
        return ion;
    }

    private void readScanIdentificationTargets(DataInputStream dataInputStream, IScanMSD scanMSD) throws IOException {
        int numberOfTargets = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfTargets) {
            String identifier = this.readString(dataInputStream);
            boolean manuallyVerified = dataInputStream.readBoolean();
            int retentionTime = dataInputStream.readInt();
            float retentionIndex = dataInputStream.readFloat();
            String casNumber = this.readString(dataInputStream);
            String comments = this.readString(dataInputStream);
            String referenceIdentifier = this.readString(dataInputStream);
            String miscellaneous = this.readString(dataInputStream);
            String database = this.readString(dataInputStream);
            String contributor = this.readString(dataInputStream);
            String name = this.readString(dataInputStream);
            HashSet<String> synonyms = new HashSet<String>();
            int numberOfSynonyms = dataInputStream.readInt();
            int j = 0;
            while (j < numberOfSynonyms) {
                synonyms.add(this.readString(dataInputStream));
                ++j;
            }
            String formula = this.readString(dataInputStream);
            String smiles = this.readString(dataInputStream);
            String inChI = this.readString(dataInputStream);
            double molWeight = dataInputStream.readDouble();
            float matchFactor = dataInputStream.readFloat();
            float matchFactorDirect = dataInputStream.readFloat();
            float reverseMatchFactor = dataInputStream.readFloat();
            float reverseMatchFactorDirect = dataInputStream.readFloat();
            float probability = dataInputStream.readFloat();
            boolean isMatch = dataInputStream.readBoolean();
            LibraryInformation libraryInformation = new LibraryInformation();
            libraryInformation.setRetentionTime(retentionTime);
            libraryInformation.setRetentionIndex(retentionIndex);
            libraryInformation.setCasNumber(casNumber);
            libraryInformation.setComments(comments);
            libraryInformation.setReferenceIdentifier(referenceIdentifier);
            libraryInformation.setMiscellaneous(miscellaneous);
            libraryInformation.setDatabase(database);
            libraryInformation.setContributor(contributor);
            libraryInformation.setName(name);
            libraryInformation.setSynonyms(synonyms);
            libraryInformation.setFormula(formula);
            libraryInformation.setSmiles(smiles);
            libraryInformation.setInChI(inChI);
            libraryInformation.setMolWeight(molWeight);
            ComparisonResult comparisonResult = new ComparisonResult(matchFactor, reverseMatchFactor, matchFactorDirect, reverseMatchFactorDirect, probability);
            comparisonResult.setMatch(isMatch);
            try {
                IdentificationTarget identificationEntry = new IdentificationTarget((ILibraryInformation)libraryInformation, (IComparisonResult)comparisonResult);
                identificationEntry.setIdentifier(identifier);
                identificationEntry.setManuallyVerified(manuallyVerified);
                scanMSD.getTargets().add(identificationEntry);
            }
            catch (ReferenceMustNotBeNullException e) {
                logger.warn((Object)e);
            }
            ++i;
        }
    }
}

