/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.converter.supplier.chemclipse.internal.io;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.converter.io.AbstractChromatogramWriter;
import org.eclipse.chemclipse.converter.io.IFileHelper;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.io.ChromatogramWriterCSD;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.io.IChromatogramCSDZipWriter;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IPeakModelCSD;
import org.eclipse.chemclipse.csd.model.core.IScanCSD;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.columns.IRetentionIndexEntry;
import org.eclipse.chemclipse.model.columns.ISeparationColumn;
import org.eclipse.chemclipse.model.columns.ISeparationColumnIndices;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.core.IMethod;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.core.RetentionIndexType;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.quantitation.IInternalStandard;
import org.eclipse.chemclipse.model.quantitation.IQuantitationEntry;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.io.ChromatogramWriterMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.support.history.IEditHistory;
import org.eclipse.chemclipse.support.history.IEditInformation;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.io.ChromatogramWriterWSD;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.preferences.PreferenceSupplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ChromatogramWriter_1301
extends AbstractChromatogramWriter
implements IChromatogramCSDZipWriter {
    public void writeChromatogram(File file, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
        zipOutputStream.setLevel(PreferenceSupplier.getChromatogramCompressionLevel());
        zipOutputStream.setMethod(8);
        this.writeChromatogram(zipOutputStream, "", chromatogram, monitor);
        zipOutputStream.flush();
        zipOutputStream.close();
    }

    @Override
    public void writeChromatogram(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws IOException {
        this.writeVersion(zipOutputStream, directoryPrefix, monitor);
        this.writeChromatogramFolder(zipOutputStream, directoryPrefix, chromatogram, monitor);
        List referencedChromatograms = chromatogram.getReferencedChromatograms();
        this.writeChromatogramReferenceInfo(zipOutputStream, directoryPrefix, referencedChromatograms, monitor);
        this.writeReferencedChromatograms(zipOutputStream, directoryPrefix, referencedChromatograms, monitor);
    }

    private void writeVersion(ZipOutputStream zipOutputStream, String directoryPrefix, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "VERSION");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        String version = "1.3.0.1";
        dataOutputStream.writeInt(version.length());
        dataOutputStream.writeChars(version);
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramFolder(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws IOException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Write Chromatogram", (int)100);
        try {
            ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "CSD/CHROMATOGRAM/");
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.closeEntry();
            this.writeChromatogramMethod(zipOutputStream, directoryPrefix, chromatogram);
            subMonitor.worked(20);
            this.writeChromatogramScans(zipOutputStream, directoryPrefix, chromatogram, (IProgressMonitor)subMonitor);
            this.writeChromatogramBaseline(zipOutputStream, directoryPrefix, chromatogram);
            subMonitor.worked(20);
            this.writeChromatogramPeaks(zipOutputStream, directoryPrefix, chromatogram);
            this.writeChromatogramArea(zipOutputStream, directoryPrefix, chromatogram);
            subMonitor.worked(20);
            this.writeChromatogramIdentification(zipOutputStream, directoryPrefix, chromatogram);
            this.writeChromatogramHistory(zipOutputStream, directoryPrefix, chromatogram);
            subMonitor.worked(20);
            this.writeChromatogramMiscellaneous(zipOutputStream, directoryPrefix, chromatogram);
            this.writeSeparationColumn(zipOutputStream, directoryPrefix, chromatogram);
            subMonitor.worked(20);
        }
        finally {
            SubMonitor.done((IProgressMonitor)subMonitor);
        }
    }

    private void writeChromatogramMethod(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramCSD chromatogram) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "CSD/CHROMATOGRAM/SYSTEM_SETTINGS");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        IMethod method = chromatogram.getMethod();
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)method.getInstrumentName());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)method.getIonSource());
        dataOutputStream.writeDouble(method.getSamplingRate());
        dataOutputStream.writeInt(method.getSolventDelay());
        dataOutputStream.writeDouble(method.getSourceHeater());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)method.getStopMode());
        dataOutputStream.writeInt(method.getStopTime());
        dataOutputStream.writeInt(method.getTimeFilterPeakWidth());
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramScans(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "CSD/CHROMATOGRAM/SCANS");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        int scans = chromatogram.getNumberOfScans();
        dataOutputStream.writeInt(scans);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Write Scans", (int)scans);
        try {
            int scan = 1;
            while (scan <= scans) {
                IScanCSD scanCSD = chromatogram.getSupplierScan(scan);
                dataOutputStream.writeInt(scanCSD.getRetentionTime());
                dataOutputStream.writeInt(scanCSD.getRelativeRetentionTime());
                dataOutputStream.writeFloat(scanCSD.getTotalSignal());
                dataOutputStream.writeInt(scanCSD.getRetentionTimeColumn1());
                dataOutputStream.writeInt(scanCSD.getRetentionTimeColumn2());
                dataOutputStream.writeFloat(scanCSD.getRetentionIndex());
                dataOutputStream.writeBoolean(scanCSD.hasAdditionalRetentionIndices());
                if (scanCSD.hasAdditionalRetentionIndices()) {
                    Map retentionIndicesTyped = scanCSD.getRetentionIndicesTyped();
                    dataOutputStream.writeInt(retentionIndicesTyped.size());
                    for (Map.Entry retentionIndexTyped : retentionIndicesTyped.entrySet()) {
                        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)((RetentionIndexType)retentionIndexTyped.getKey()).toString());
                        dataOutputStream.writeFloat(((Float)retentionIndexTyped.getValue()).floatValue());
                    }
                }
                dataOutputStream.writeInt(scanCSD.getTimeSegmentId());
                dataOutputStream.writeInt(scanCSD.getCycleNumber());
                Set scanTargets = scanCSD.getTargets();
                dataOutputStream.writeInt(scanTargets.size());
                for (IIdentificationTarget scanTarget : scanTargets) {
                    if (!(scanTarget instanceof IIdentificationTarget)) continue;
                    IIdentificationTarget identificationEntry = scanTarget;
                    this.writeIdentificationEntry(dataOutputStream, identificationEntry);
                }
                subMonitor.worked(1);
                ++scan;
            }
        }
        finally {
            SubMonitor.done((IProgressMonitor)subMonitor);
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramBaseline(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramCSD chromatogram) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "CSD/CHROMATOGRAM/BASELINE");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        int scans = chromatogram.getNumberOfScans();
        dataOutputStream.writeInt(scans);
        IBaselineModel baselineModel = chromatogram.getBaselineModel();
        int scan = 1;
        while (scan <= scans) {
            int retentionTime = chromatogram.getSupplierScan(scan).getRetentionTime();
            float backgroundAbundance = baselineModel.getBackground(retentionTime);
            dataOutputStream.writeInt(retentionTime);
            dataOutputStream.writeFloat(backgroundAbundance);
            ++scan;
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramPeaks(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramCSD chromatogram) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "CSD/CHROMATOGRAM/PEAKS");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        List peaks = chromatogram.getPeaks();
        dataOutputStream.writeInt(peaks.size());
        for (IChromatogramPeakCSD peak : peaks) {
            this.writePeak(dataOutputStream, (IPeakCSD)peak);
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramArea(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramCSD chromatogram) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "CSD/CHROMATOGRAM/AREA");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        List chromatogramIntegrationEntries = chromatogram.getChromatogramIntegrationEntries();
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)chromatogram.getIntegratorDescription());
        this.writeIntegrationEntries(dataOutputStream, chromatogramIntegrationEntries);
        List backgroundIntegrationEntries = chromatogram.getBackgroundIntegrationEntries();
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)chromatogram.getIntegratorDescription());
        this.writeIntegrationEntries(dataOutputStream, backgroundIntegrationEntries);
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writePeak(DataOutputStream dataOutputStream, IPeakCSD peak) throws IOException {
        IPeakModelCSD peakModel = peak.getPeakModel();
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)peak.getDetectorDescription());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)peak.getQuantifierDescription());
        dataOutputStream.writeBoolean(peak.isActiveForAnalysis());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)peak.getIntegratorDescription());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)peak.getModelDescription());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)peak.getPeakType().toString());
        dataOutputStream.writeInt(peak.getSuggestedNumberOfComponents());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)peak.getName());
        IFileHelper.writeStringCollection((DataOutputStream)dataOutputStream, (Collection)peak.getClassifier());
        dataOutputStream.writeFloat(peakModel.getBackgroundAbundance(peakModel.getStartRetentionTime()));
        dataOutputStream.writeFloat(peakModel.getBackgroundAbundance(peakModel.getStopRetentionTime()));
        IScan scan = peakModel.getPeakMaximum();
        dataOutputStream.writeInt(scan.getRetentionTime());
        dataOutputStream.writeInt(scan.getRelativeRetentionTime());
        dataOutputStream.writeFloat(scan.getTotalSignal());
        dataOutputStream.writeInt(scan.getRetentionTimeColumn1());
        dataOutputStream.writeInt(scan.getRetentionTimeColumn2());
        dataOutputStream.writeFloat(scan.getRetentionIndex());
        dataOutputStream.writeBoolean(scan.hasAdditionalRetentionIndices());
        if (scan.hasAdditionalRetentionIndices()) {
            Map retentionIndicesTyped = scan.getRetentionIndicesTyped();
            dataOutputStream.writeInt(retentionIndicesTyped.size());
            for (Map.Entry retentionIndexTyped : retentionIndicesTyped.entrySet()) {
                IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)((RetentionIndexType)retentionIndexTyped.getKey()).toString());
                dataOutputStream.writeFloat(((Float)retentionIndexTyped.getValue()).floatValue());
            }
        }
        dataOutputStream.writeInt(scan.getTimeSegmentId());
        dataOutputStream.writeInt(scan.getCycleNumber());
        List retentionTimes = peakModel.getRetentionTimes();
        dataOutputStream.writeInt(retentionTimes.size());
        Iterator iterator = retentionTimes.iterator();
        while (iterator.hasNext()) {
            int retentionTime = (Integer)((Object)iterator.next());
            dataOutputStream.writeInt(retentionTime);
            dataOutputStream.writeFloat(peakModel.getPeakAbundance(retentionTime));
        }
        List integrationEntries = peak.getIntegrationEntries();
        this.writeIntegrationEntries(dataOutputStream, integrationEntries);
        Set peakTargets = peak.getTargets();
        dataOutputStream.writeInt(peakTargets.size());
        for (IIdentificationTarget peakTarget : peakTargets) {
            if (!(peakTarget instanceof IIdentificationTarget)) continue;
            IIdentificationTarget identificationEntry = peakTarget;
            this.writeIdentificationEntry(dataOutputStream, identificationEntry);
        }
        List quantitationEntries = peak.getQuantitationEntries();
        dataOutputStream.writeInt(quantitationEntries.size());
        for (IQuantitationEntry quantitationEntry : quantitationEntries) {
            IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)quantitationEntry.getName());
            IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)quantitationEntry.getChemicalClass());
            dataOutputStream.writeDouble(quantitationEntry.getConcentration());
            IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)quantitationEntry.getConcentrationUnit());
            dataOutputStream.writeDouble(quantitationEntry.getArea());
            IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)quantitationEntry.getCalibrationMethod());
            dataOutputStream.writeBoolean(quantitationEntry.getUsedCrossZero());
            IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)quantitationEntry.getDescription());
            if (quantitationEntry.getSignal() != 0.0) {
                dataOutputStream.writeBoolean(true);
                dataOutputStream.writeDouble(quantitationEntry.getSignal());
                continue;
            }
            dataOutputStream.writeBoolean(false);
        }
        this.writeIntenalStandards(dataOutputStream, peak.getInternalStandards());
    }

    private void writeIntegrationEntries(DataOutputStream dataOutputStream, List<? extends IIntegrationEntry> integrationEntries) throws IOException {
        dataOutputStream.writeInt(integrationEntries.size());
        for (IIntegrationEntry iIntegrationEntry : integrationEntries) {
            dataOutputStream.writeDouble(iIntegrationEntry.getIntegratedArea());
        }
    }

    private void writeIntenalStandards(DataOutputStream dataOutputStream, List<IInternalStandard> internalStandards) throws IOException {
        dataOutputStream.writeInt(internalStandards.size());
        for (IInternalStandard internalStandard : internalStandards) {
            IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)internalStandard.getName());
            dataOutputStream.writeDouble(internalStandard.getConcentration());
            IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)internalStandard.getConcentrationUnit());
            dataOutputStream.writeDouble(internalStandard.getResponseFactor());
            IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)internalStandard.getChemicalClass());
        }
    }

    private void writeChromatogramIdentification(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramCSD chromatogram) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "CSD/CHROMATOGRAM/IDENTIFICATION");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        Set chromatogramTargets = chromatogram.getTargets();
        dataOutputStream.writeInt(chromatogramTargets.size());
        for (IIdentificationTarget chromatogramTarget : chromatogramTargets) {
            if (!(chromatogramTarget instanceof IIdentificationTarget)) continue;
            IIdentificationTarget identificationEntry = chromatogramTarget;
            this.writeIdentificationEntry(dataOutputStream, identificationEntry);
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeIdentificationEntry(DataOutputStream dataOutputStream, IIdentificationTarget identificationEntry) throws IOException {
        ILibraryInformation libraryInformation = identificationEntry.getLibraryInformation();
        IComparisonResult comparisonResult = identificationEntry.getComparisonResult();
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)identificationEntry.getIdentifier());
        dataOutputStream.writeBoolean(identificationEntry.isManuallyVerified());
        dataOutputStream.writeInt(libraryInformation.getRetentionTime());
        dataOutputStream.writeFloat(libraryInformation.getRetentionIndex());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)libraryInformation.getCasNumber());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)libraryInformation.getComments());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)libraryInformation.getReferenceIdentifier());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)libraryInformation.getMiscellaneous());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)libraryInformation.getDatabase());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)libraryInformation.getContributor());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)libraryInformation.getName());
        Set synonyms = libraryInformation.getSynonyms();
        int numberOfSynonyms = synonyms.size();
        dataOutputStream.writeInt(numberOfSynonyms);
        for (String synonym : synonyms) {
            IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)synonym);
        }
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)libraryInformation.getFormula());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)libraryInformation.getSmiles());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)libraryInformation.getInChI());
        dataOutputStream.writeDouble(libraryInformation.getMolWeight());
        dataOutputStream.writeFloat(comparisonResult.getMatchFactor());
        dataOutputStream.writeFloat(comparisonResult.getMatchFactorDirect());
        dataOutputStream.writeFloat(comparisonResult.getReverseMatchFactor());
        dataOutputStream.writeFloat(comparisonResult.getReverseMatchFactorDirect());
        dataOutputStream.writeFloat(comparisonResult.getProbability());
        dataOutputStream.writeBoolean(comparisonResult.isMatch());
    }

    private void writeChromatogramHistory(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramCSD chromatogram) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "CSD/CHROMATOGRAM/HISTORY");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        IEditHistory editHistory = chromatogram.getEditHistory();
        dataOutputStream.writeInt(editHistory.size());
        for (IEditInformation editInformation : editHistory) {
            dataOutputStream.writeLong(editInformation.getDate().getTime());
            IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)editInformation.getDescription());
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramMiscellaneous(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramCSD chromatogram) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "CSD/CHROMATOGRAM/MISC");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        Map headerData = chromatogram.getHeaderDataMap();
        dataOutputStream.writeInt(headerData.size());
        for (Map.Entry data : headerData.entrySet()) {
            IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)((String)data.getKey()));
            IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)((String)data.getValue()));
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeSeparationColumn(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramCSD chromatogram) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "CSD/CHROMATOGRAM/SEPARATION_COLUMN");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        ISeparationColumnIndices separationColumnIndices = chromatogram.getSeparationColumnIndices();
        dataOutputStream.writeInt(separationColumnIndices.size());
        for (Map.Entry entry : separationColumnIndices.entrySet()) {
            IRetentionIndexEntry retentionIndexEntry = (IRetentionIndexEntry)entry.getValue();
            IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)retentionIndexEntry.getName());
            dataOutputStream.writeInt(retentionIndexEntry.getRetentionTime());
            dataOutputStream.writeFloat(retentionIndexEntry.getRetentionIndex());
        }
        ISeparationColumn separationColumn = separationColumnIndices.getSeparationColumn();
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)separationColumn.getName());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)separationColumn.getLength());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)separationColumn.getDiameter());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)separationColumn.getPhase());
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramReferenceInfo(ZipOutputStream zipOutputStream, String directoryPrefix, List<IChromatogram<?>> referencedChromatograms, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntryType = new ZipEntry(String.valueOf(directoryPrefix) + "REFERENCE_INFO");
        zipOutputStream.putNextEntry(zipEntryType);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        dataOutputStream.writeInt(referencedChromatograms.size());
        zipOutputStream.closeEntry();
    }

    private void writeReferencedChromatograms(ZipOutputStream zipOutputStream, String directoryPrefix, List<IChromatogram<?>> referencedChromatograms, IProgressMonitor monitor) throws IOException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Write Chromatogram", (int)(referencedChromatograms.size() * 20));
        try {
            ChromatogramWriterMSD chromatogramWriterMSD = new ChromatogramWriterMSD();
            ChromatogramWriterCSD chromatogramWriterCSD = new ChromatogramWriterCSD();
            ChromatogramWriterWSD chromatogramWriterWSD = new ChromatogramWriterWSD();
            int i = 0;
            for (IChromatogram<?> referencedChromatogram : referencedChromatograms) {
                ZipEntry zipEntryChromtogram;
                String prefix = String.valueOf(directoryPrefix) + "CHROMATOGRAM_REFERENCE" + "_" + i++ + "/";
                ZipEntry zipEntryType = new ZipEntry(String.valueOf(prefix) + "CHROMATOGRAM_TYPE");
                zipOutputStream.putNextEntry(zipEntryType);
                DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
                if (referencedChromatogram instanceof IChromatogramMSD) {
                    IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)"MSD");
                    dataOutputStream.flush();
                    prefix = String.valueOf(prefix) + "CHROMATOGRAM_REFERENCE/";
                    zipEntryChromtogram = new ZipEntry(prefix);
                    zipOutputStream.putNextEntry(zipEntryChromtogram);
                    chromatogramWriterMSD.writeChromatogram(zipOutputStream, prefix, (IChromatogramMSD)referencedChromatogram, monitor);
                } else if (referencedChromatogram instanceof IChromatogramCSD) {
                    IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)"CSD");
                    dataOutputStream.flush();
                    prefix = String.valueOf(prefix) + "CHROMATOGRAM_REFERENCE/";
                    zipEntryChromtogram = new ZipEntry(prefix);
                    zipOutputStream.putNextEntry(zipEntryChromtogram);
                    chromatogramWriterCSD.writeChromatogram(zipOutputStream, prefix, (IChromatogramCSD)referencedChromatogram, monitor);
                } else if (referencedChromatogram instanceof IChromatogramWSD) {
                    IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)"WSD");
                    dataOutputStream.flush();
                    prefix = String.valueOf(prefix) + "CHROMATOGRAM_REFERENCE/";
                    zipEntryChromtogram = new ZipEntry(prefix);
                    zipOutputStream.putNextEntry(zipEntryChromtogram);
                    chromatogramWriterWSD.writeChromatogram(zipOutputStream, prefix, (IChromatogramWSD)referencedChromatogram, monitor);
                }
                subMonitor.worked(20);
                zipOutputStream.closeEntry();
            }
        }
        finally {
            SubMonitor.done((IProgressMonitor)subMonitor);
        }
    }
}

