/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.support;

import org.eclipse.chemclipse.model.support.IRetentionTimeRange;

public class RetentionTimeRange
implements IRetentionTimeRange {
    private int startRetentionTime;
    private int stopRetentionTime;

    public RetentionTimeRange(IRetentionTimeRange range) {
        this(range.getStartRetentionTime(), range.getStopRetentionTime());
    }

    public RetentionTimeRange(int startRetentionTime, int stopRetentionTime) {
        if (startRetentionTime < 0) {
            startRetentionTime = 0;
        }
        if (stopRetentionTime < 0) {
            stopRetentionTime = 0;
        }
        if (startRetentionTime > stopRetentionTime) {
            this.startRetentionTime = stopRetentionTime;
            this.stopRetentionTime = startRetentionTime;
        } else {
            this.startRetentionTime = startRetentionTime;
            this.stopRetentionTime = stopRetentionTime;
        }
    }

    @Override
    public int getStartRetentionTime() {
        return this.startRetentionTime;
    }

    @Override
    public int getStopRetentionTime() {
        return this.stopRetentionTime;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        RetentionTimeRange otherRange = (RetentionTimeRange)other;
        return this.getStartRetentionTime() == otherRange.getStartRetentionTime() && this.getStopRetentionTime() == otherRange.getStopRetentionTime();
    }

    public int hashCode() {
        return 7 * Integer.valueOf(this.startRetentionTime).hashCode() + 11 * Integer.valueOf(this.stopRetentionTime).hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("startRetentionTime=" + this.startRetentionTime);
        builder.append(",");
        builder.append("stopRetentionTime=" + this.stopRetentionTime);
        builder.append("]");
        return builder.toString();
    }
}

