/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.support;

import org.eclipse.chemclipse.model.core.IScan;

public interface IScanRange {
    public static final int MIN_SCAN = 1;
    public static final int MAX_SCAN = Integer.MAX_VALUE;

    public int getStartScan();

    public int getStopScan();

    default public int getWidth() {
        int stopScan = this.getStopScan();
        int startScan = this.getStartScan();
        if (startScan == stopScan) {
            return 0;
        }
        return stopScan - startScan + 1;
    }

    default public boolean contentEquals(IScanRange other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getStopScan() == other.getStopScan() && this.getStartScan() == other.getStartScan();
    }

    default public boolean containsScan(IScan scan) {
        return this.containsScan(scan.getScanNumber());
    }

    default public boolean containsScan(int scan) {
        return scan >= this.getStartScan() && scan <= this.getStopScan();
    }
}

