/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.model.support.IRetentionTimeRange;
import org.eclipse.chemclipse.model.support.IScanRange;

public interface IAnalysisSegment
extends IScanRange,
IRetentionTimeRange {
    @Deprecated
    default public int getSegmentWidth() {
        return this.getWidth();
    }

    default public Collection<? extends IAnalysisSegment> getChildSegments() {
        return Collections.emptyList();
    }

    public static <T extends IAnalysisSegment> List<T> getSegments(IScanRange range, boolean includeBorders, Collection<T> segments) {
        ArrayList<IAnalysisSegment> list = new ArrayList<IAnalysisSegment>();
        for (IAnalysisSegment segment : segments) {
            if (range.containsScan(segment.getStartScan())) {
                if (!includeBorders && segment.getStopScan() > range.getStopScan()) continue;
                list.add(segment);
                continue;
            }
            if (!includeBorders || !range.containsScan(segment.getStopScan())) continue;
            list.add(segment);
        }
        Collections.sort(list, (o1, o2) -> o1.getStartScan() - o2.getStartScan());
        return list;
    }
}

