/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.ranges;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.ranges.TimeRange;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.support.util.TimeRangeListUtil;

public class TimeRanges {
    private static final Logger logger = Logger.getLogger(TimeRanges.class);
    private TimeRangeListUtil timeRangeListUtil = new TimeRangeListUtil();
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.000");
    private final Map<String, TimeRange> timeRangeMap = new HashMap<String, TimeRange>();

    public TimeRanges() {
    }

    public TimeRanges(String timeRanges) {
        this.load(timeRanges);
    }

    public void addAll(Collection<TimeRange> timeRanges) {
        for (TimeRange timeRange : timeRanges) {
            this.add(timeRange);
        }
    }

    public void add(TimeRange timeRange) {
        this.timeRangeMap.put(timeRange.getIdentifier(), timeRange);
    }

    public void remove(String identifier) {
        this.timeRangeMap.remove(identifier);
    }

    public void remove(List<TimeRange> timeRanges) {
        for (TimeRange timeRange : timeRanges) {
            this.remove(timeRange);
        }
    }

    public void remove(TimeRange timeRange) {
        if (timeRange != null) {
            this.timeRangeMap.remove(timeRange.getIdentifier());
        }
    }

    public TimeRange get(String identifier) {
        return this.timeRangeMap.get(identifier);
    }

    public Set<String> keySet() {
        return this.timeRangeMap.keySet();
    }

    public Collection<TimeRange> values() {
        return this.timeRangeMap.values();
    }

    public void clear() {
        this.timeRangeMap.clear();
    }

    public String extractTimeRange(TimeRange timeRange) {
        StringBuilder builder = new StringBuilder();
        this.extractTimeRange(timeRange, builder);
        return builder.toString();
    }

    public TimeRange extractTimeRange(String item) {
        TimeRange timeRange = null;
        if (!"".equals(item)) {
            String[] values = item.split("\\|");
            String identifier = values.length > 0 ? values[0].trim() : "";
            int start = values.length > 1 ? this.calculateRetentionTime(values[1]) : 0;
            int center = values.length > 2 ? this.calculateRetentionTime(values[2]) : 0;
            int stop = values.length > 3 ? this.calculateRetentionTime(values[3]) : 0;
            timeRange = new TimeRange(identifier, start, center, stop);
        }
        return timeRange;
    }

    public void load(String timeRanges) {
        this.loadSettings(timeRanges);
    }

    public void loadDefault(String timeRanges) {
        this.loadSettings(timeRanges);
    }

    public String save() {
        StringBuilder builder = new StringBuilder();
        Iterator<TimeRange> iterator = this.values().iterator();
        while (iterator.hasNext()) {
            TimeRange timeRange = iterator.next();
            this.extractTimeRange(timeRange, builder);
            if (!iterator.hasNext()) continue;
            builder.append(";");
        }
        return builder.toString().trim();
    }

    public void importItems(File file) {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    TimeRange template = this.extractTimeRange(line);
                    if (template == null) continue;
                    this.add(template);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e);
        }
        catch (IOException e) {
            logger.warn((Object)e);
        }
    }

    public boolean exportItems(File file) {
        Throwable throwable = null;
        Object var3_5 = null;
        PrintWriter printWriter = new PrintWriter(file);
        try {
            ArrayList<TimeRange> timeRanges = new ArrayList<TimeRange>(this.values());
            Collections.sort(timeRanges, (r1, r2) -> Integer.compare(r1.getStart(), r2.getStart()));
            Iterator iterator = timeRanges.iterator();
            while (iterator.hasNext()) {
                StringBuilder builder = new StringBuilder();
                TimeRange template = (TimeRange)iterator.next();
                this.extractTimeRange(template, builder);
                printWriter.println(builder.toString());
            }
            printWriter.flush();
            if (printWriter != null) {
                printWriter.close();
            }
            return true;
        }
        catch (Throwable throwable2) {
            try {
                try {
                    if (printWriter != null) {
                        printWriter.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)e);
                return false;
            }
        }
    }

    private void loadSettings(String timeRanges) {
        String[] items;
        if (!"".equals(timeRanges) && (items = this.timeRangeListUtil.parseString(timeRanges)).length > 0) {
            String[] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                TimeRange timeRange = this.extractTimeRange(item);
                if (timeRange != null) {
                    this.add(timeRange);
                }
                ++n2;
            }
        }
    }

    private int calculateRetentionTime(String minutes) {
        try {
            return (int)(Double.parseDouble(minutes.trim()) * 60000.0);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private String calculateRetentionTimeMinutes(int retentionTime) {
        return this.decimalFormat.format((float)retentionTime / 60000.0f);
    }

    private void extractTimeRange(TimeRange timeRange, StringBuilder builder) {
        builder.append(timeRange.getIdentifier());
        builder.append(" ");
        builder.append("|");
        builder.append(" ");
        builder.append(this.calculateRetentionTimeMinutes(timeRange.getStart()));
        builder.append(" ");
        builder.append("|");
        builder.append(" ");
        builder.append(this.calculateRetentionTimeMinutes(timeRange.getCenter()));
        builder.append(" ");
        builder.append("|");
        builder.append(" ");
        builder.append(this.calculateRetentionTimeMinutes(timeRange.getStop()));
    }
}

