/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.core;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IMeasurementInfo;
import org.eclipse.chemclipse.model.exceptions.InvalidHeaderModificationException;
import org.eclipse.chemclipse.model.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.support.text.ValueFormat;

public abstract class AbstractMeasurementInfo
implements IMeasurementInfo {
    private static final long serialVersionUID = 4247159773898302230L;
    private static final Logger logger = Logger.getLogger(AbstractMeasurementInfo.class);
    private Set<String> protectKeys;
    private Map<String, String> headerDataMap;
    private DateFormat dateFormat = ValueFormat.getDateFormatEnglish((String)"yyyy/MM/dd HH:mm:ss");

    public AbstractMeasurementInfo(Map<String, String> headerData) {
        this.headerDataMap = headerData != null ? new LinkedHashMap<String, String>(headerData) : new LinkedHashMap<String, String>();
        this.headerDataMap.putIfAbsent("Operator", "");
        this.headerDataMap.putIfAbsent("Date", this.dateFormat.format(new Date()));
        this.headerDataMap.putIfAbsent("Misc Info", "");
        this.headerDataMap.putIfAbsent("Misc Info Separated", "");
        this.headerDataMap.putIfAbsent("Short Info", "");
        this.headerDataMap.putIfAbsent("Detailed Info", "");
        this.headerDataMap.putIfAbsent("Sample Group", "");
        this.headerDataMap.putIfAbsent("Barcode", "");
        this.headerDataMap.putIfAbsent("Barcode Type", "");
        this.headerDataMap.putIfAbsent("Sample Weight", Double.valueOf(0.0).toString());
        this.headerDataMap.putIfAbsent("Sample Weight Unit", "");
        this.headerDataMap.putIfAbsent("Data Name", "");
        this.protectKeys = new HashSet<String>(Arrays.asList("Operator", "Date", "Misc Info", "Misc Info Separated", "Short Info", "Detailed Info", "Sample Group", "Barcode", "Barcode Type", "Sample Weight", "Sample Weight Unit", "Data Name"));
    }

    public AbstractMeasurementInfo() {
        this(null);
    }

    @Override
    public String getHeaderData(String key) {
        return this.headerDataMap.get(key);
    }

    @Override
    public String getHeaderDataOrDefault(String key, String defaultValue) {
        return this.headerDataMap.getOrDefault(key, defaultValue);
    }

    @Override
    public boolean headerDataContainsKey(String key) {
        return this.headerDataMap.containsKey(key);
    }

    @Override
    public void putHeaderData(String key, String value) {
        this.headerDataMap.put(key, value);
    }

    @Override
    public void removeHeaderData(String key) throws InvalidHeaderModificationException {
        if (this.protectKeys.contains(key)) {
            throw new InvalidHeaderModificationException("It's not possible to remove the following key: " + key);
        }
        this.headerDataMap.remove(key);
    }

    @Override
    public Map<String, String> getHeaderDataMap() {
        return Collections.unmodifiableMap(this.headerDataMap);
    }

    protected void setHeaderDataMap(Map<String, String> headerDataMap) {
        this.headerDataMap = headerDataMap;
    }

    @Override
    public String getOperator() {
        return this.getHeaderData("Operator");
    }

    @Override
    public void setOperator(String operator) {
        this.putHeaderData("Operator", operator);
    }

    @Override
    public Date getDate() {
        try {
            return this.dateFormat.parse(this.getHeaderData("Date"));
        }
        catch (ParseException e) {
            logger.warn((Object)e);
            return new Date();
        }
    }

    @Override
    public void setDate(Date date) {
        if (date != null) {
            this.putHeaderData("Date", this.dateFormat.format(date));
        } else {
            this.putHeaderData("Date", "");
        }
    }

    @Override
    public String getMiscInfo() {
        return this.getHeaderData("Misc Info");
    }

    @Override
    public void setMiscInfo(String miscInfo) {
        if (miscInfo != null) {
            String[] values = miscInfo.split(PreferenceSupplier.getMiscSeparator());
            if (values.length >= 2) {
                this.putHeaderData("Misc Info", values[0]);
                StringBuilder builder = new StringBuilder();
                int i = 1;
                while (i < values.length) {
                    builder.append(values[i].trim());
                    builder.append(PreferenceSupplier.getMiscSeparatedDelimiter());
                    ++i;
                }
                this.putHeaderData("Misc Info Separated", builder.toString().trim());
            } else {
                this.putHeaderData("Misc Info", miscInfo);
            }
        } else {
            this.putHeaderData("Misc Info", "");
            this.putHeaderData("Misc Info Separated", "");
        }
    }

    @Override
    public String getMiscInfoSeparated() {
        return this.getHeaderData("Misc Info Separated");
    }

    @Override
    public void setMiscInfoSeparated(String miscInfoSeparated) {
        this.putHeaderData("Misc Info Separated", miscInfoSeparated);
    }

    @Override
    public String getShortInfo() {
        return this.getHeaderData("Short Info");
    }

    @Override
    public void setShortInfo(String shortInfo) {
        if (shortInfo != null) {
            this.putHeaderData("Short Info", shortInfo);
        } else {
            this.putHeaderData("Short Info", "");
        }
    }

    @Override
    public String getDetailedInfo() {
        return this.getHeaderData("Detailed Info");
    }

    @Override
    public void setDetailedInfo(String detailedInfo) {
        if (detailedInfo != null) {
            this.putHeaderData("Detailed Info", detailedInfo);
        } else {
            this.putHeaderData("Detailed Info", "");
        }
    }

    @Override
    public String getSampleGroup() {
        return this.getHeaderData("Sample Group");
    }

    @Override
    public void setSampleGroup(String sampleGroup) {
        if (sampleGroup != null) {
            this.putHeaderData("Sample Group", sampleGroup);
        } else {
            this.putHeaderData("Sample Group", "");
        }
    }

    @Override
    public String getBarcode() {
        return this.getHeaderData("Barcode");
    }

    @Override
    public void setBarcode(String barcode) {
        if (barcode != null) {
            this.putHeaderData("Barcode", barcode);
        } else {
            this.putHeaderData("Barcode", "");
        }
    }

    @Override
    public String getBarcodeType() {
        return this.getHeaderData("Barcode Type");
    }

    @Override
    public void setBarcodeType(String barcodeType) {
        if (barcodeType != null) {
            this.putHeaderData("Barcode Type", barcodeType);
        } else {
            this.putHeaderData("Barcode Type", "");
        }
    }

    @Override
    public double getSampleWeight() {
        try {
            return Double.parseDouble(this.getHeaderData("Sample Weight"));
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    @Override
    public void setSampleWeight(double sampleWeight) {
        if (sampleWeight >= 0.0) {
            this.headerDataMap.put("Sample Weight", Double.valueOf(sampleWeight).toString());
        } else {
            this.headerDataMap.put("Sample Weight", Double.valueOf(0.0).toString());
        }
    }

    @Override
    public String getSampleWeightUnit() {
        return this.getHeaderData("Sample Weight Unit");
    }

    @Override
    public void setSampleWeightUnit(String sampleWeightUnit) {
        if (sampleWeightUnit != null) {
            this.putHeaderData("Sample Weight Unit", sampleWeightUnit);
        } else {
            this.putHeaderData("Sample Weight Unit", "");
        }
    }

    @Override
    public String getDataName() {
        return this.getHeaderData("Data Name");
    }

    @Override
    public void setDataName(String dataName) {
        if (dataName != null) {
            this.putHeaderData("Data Name", dataName);
        } else {
            this.putHeaderData("Data Name", "");
        }
    }
}

