/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.filter.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.filter.core.chromatogram.AbstractChromatogramFilter;
import org.eclipse.chemclipse.chromatogram.filter.core.chromatogram.IChromatogramFilter;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.selection.ChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.support.IRetentionTimeRange;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.ChromatogramSelectionWSD;

public abstract class AbstractTransferFilter
extends AbstractChromatogramFilter
implements IChromatogramFilter {
    protected List<IScan> extractIdentifiedScans(IChromatogramSelection chromatogramSelection) {
        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
        int startRetentionTime = chromatogramSelection.getStartRetentionTime();
        int stopRetentionTime = chromatogramSelection.getStopRetentionTime();
        int startScan = chromatogram.getScanNumber(startRetentionTime);
        int stopScan = chromatogram.getScanNumber(stopRetentionTime);
        ArrayList<IScan> identifiedScans = new ArrayList<IScan>();
        int i = startScan;
        while (i <= stopScan) {
            IScan scan = chromatogram.getScan(i);
            if (scan.getTargets().size() > 0) {
                identifiedScans.add(scan);
            }
            ++i;
        }
        return identifiedScans;
    }

    protected List<? extends IPeak> extractPeaks(IChromatogram chromatogram) {
        if (chromatogram instanceof IChromatogramCSD) {
            return this.extractPeaks((IChromatogramSelection)new ChromatogramSelectionCSD((IChromatogramCSD)chromatogram));
        }
        if (chromatogram instanceof IChromatogramMSD) {
            return this.extractPeaks((IChromatogramSelection)new ChromatogramSelectionMSD((IChromatogramMSD)chromatogram));
        }
        if (chromatogram instanceof IChromatogramWSD) {
            return this.extractPeaks((IChromatogramSelection)new ChromatogramSelectionWSD((IChromatogramWSD)chromatogram));
        }
        return new ArrayList();
    }

    protected List<? extends IPeak> extractPeaks(IChromatogramSelection chromatogramSelection) {
        return chromatogramSelection.getChromatogram().getPeaks((IRetentionTimeRange)chromatogramSelection);
    }
}

