/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.handlers;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.modifier.CalculatorRunnable;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.progress.core.InfoType;
import org.eclipse.chemclipse.progress.core.StatusLineLogger;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class CalculatorHandler
implements EventHandler {
    private static final Logger logger = Logger.getLogger(CalculatorHandler.class);
    private static IChromatogramSelection chromatogramSelection;

    @Execute
    public void execute() {
        if (chromatogramSelection != null) {
            Display display = Display.getCurrent();
            StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"Start RI Calculator Filter");
            CalculatorRunnable runnable = new CalculatorRunnable(chromatogramSelection);
            ProgressMonitorDialog monitor = new ProgressMonitorDialog(display.getActiveShell());
            try {
                monitor.run(true, true, (IRunnableWithProgress)runnable);
            }
            catch (InvocationTargetException e) {
                logger.warn((Object)e);
            }
            catch (InterruptedException e) {
                logger.warn((Object)e);
            }
            StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"RI Calculator finished");
        }
    }

    public void handleEvent(Event event) {
        chromatogramSelection = event.getTopic().equals("chromatogram/msd/update/chromatogramselection") ? (IChromatogramSelectionMSD)event.getProperty("ChromatogramSelection") : (event.getTopic().equals("chromatogram/csd/update/chromatogramselection") ? (IChromatogramSelectionCSD)event.getProperty("ChromatogramSelection") : (event.getTopic().equals("chromatogram/wsd/update/chromatogramselection") ? (IChromatogramSelectionWSD)event.getProperty("ChromatogramSelection") : null));
    }
}

