/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.runnables;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.core.PeakQuantifier;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class QuantifyPeaksRunnableESTD
implements IRunnableWithProgress {
    private IChromatogramSelectionMSD chromatogramSelection;
    private static final String PEAK_QUANTIFIER_ID = "org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.peak";

    public QuantifyPeaksRunnableESTD(IChromatogramSelectionMSD chromatogramSelection) {
        this.chromatogramSelection = chromatogramSelection;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask("Peak List Quantifier (ESTD)", -1);
            ArrayList<IChromatogramPeakMSD> peaks = new ArrayList<IChromatogramPeakMSD>();
            for (IChromatogramPeakMSD peak : this.chromatogramSelection.getChromatogramMSD().getPeaks()) {
                peaks.add(peak);
            }
            IProcessingInfo processingInfo = PeakQuantifier.quantify(peaks, (String)PEAK_QUANTIFIER_ID, (IProgressMonitor)monitor);
            ProcessingInfoViewSupport.updateProcessingInfo((MessageProvider)processingInfo, (boolean)true);
            if (this.chromatogramSelection instanceof ChromatogramSelectionMSD) {
                ((ChromatogramSelectionMSD)this.chromatogramSelection).update(true);
            }
        }
        finally {
            monitor.done();
        }
    }
}

