/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.handlers;

import javax.inject.Named;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.io.DatabaseSupport;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.wizards.AddPeakWizardESTD;
import org.eclipse.chemclipse.model.quantitation.IQuantitationDatabase;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.progress.core.InfoType;
import org.eclipse.chemclipse.progress.core.StatusLineLogger;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class AddPeakHandlerESTD
implements EventHandler {
    private static IChromatogramSelectionMSD chromatogramSelection;

    @Execute
    public void execute(Shell shell, @Named(value="e4ActivePart") MPart part) {
        IChromatogramPeakMSD chromatogramPeakMSD;
        if (chromatogramSelection != null && (chromatogramPeakMSD = (IChromatogramPeakMSD)chromatogramSelection.getSelectedPeak()) != null) {
            DatabaseSupport databaseSupport = new DatabaseSupport();
            IQuantitationDatabase quantitationDatabase = databaseSupport.load();
            if (quantitationDatabase != null && quantitationDatabase.size() >= 0) {
                AddPeakWizardESTD wizard = new AddPeakWizardESTD(quantitationDatabase, chromatogramPeakMSD);
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                if (dialog.open() == 0) {
                    StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"Done: The peak has been successfully added to the quantitation table.");
                }
                databaseSupport.save(quantitationDatabase);
            } else {
                MessageDialog.openWarning((Shell)shell, (String)"Quantitation", (String)"Please select a quantitation table previously.");
                StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"There is no quantitation table available.");
            }
        }
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("chromatogram/msd/update/chromatogramselection")) {
            chromatogramSelection = (IChromatogramSelectionMSD)event.getProperty("ChromatogramSelection");
        }
    }
}

