/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.amdis.converter.elu;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.converter.peak.AbstractPeakImportConverter;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.internal.converter.SpecificationValidatorELU;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.io.ELUReader;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.IProgressMonitor;

public class ELUPeakImportConverter
extends AbstractPeakImportConverter {
    private static final Logger logger = Logger.getLogger(ELUPeakImportConverter.class);

    public IProcessingInfo convert(File file, IProgressMonitor monitor) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        try {
            super.validate(file);
            file = SpecificationValidatorELU.validateSpecification(file);
            ELUReader peakReader = new ELUReader();
            processingInfo = peakReader.read(file, monitor);
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e);
            ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Import Peaks", "The given file was not found: " + file.getAbsolutePath());
            processingInfo.addMessage((IProcessingMessage)processingMessage);
        }
        catch (FileIsNotReadableException e) {
            logger.warn((Object)e);
            ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Import Peaks", "The given file is not readable: " + file.getAbsolutePath());
            processingInfo.addMessage((IProcessingMessage)processingMessage);
        }
        catch (FileIsEmptyException e) {
            logger.warn((Object)e);
            ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Import Peaks", "The given file is empty: " + file.getAbsolutePath());
            processingInfo.addMessage((IProcessingMessage)processingMessage);
        }
        catch (IOException e) {
            logger.warn((Object)e);
            ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Import Peaks", "There has gone something wrong reading the file: " + file.getAbsolutePath());
            processingInfo.addMessage((IProcessingMessage)processingMessage);
        }
        return processingInfo;
    }
}

