/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.CompositeList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.FunctionList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.UniqueList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.impl.GlazedListsImpl;
import ca.odell.glazedlists.impl.filter.SearchTerm;
import ca.odell.glazedlists.impl.filter.TextMatcher;
import ca.odell.glazedlists.impl.swing.ComboBoxPopupLocationFix;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.Matchers;
import ca.odell.glazedlists.matchers.TextMatcherEditor;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

public final class AutoCompleteSupport<E> {
    private static final ParsePosition PARSE_POSITION = new ParsePosition(0);
    private static final Class[] VALUE_OF_SIGNATURE = new Class[]{String.class};
    private static final Object NOT_FOUND = new Object();
    private boolean correctsCase = true;
    private boolean strict = false;
    private boolean beepOnStrictViolation = true;
    private boolean selectsTextOnFocusGain = true;
    private boolean hidesPopupOnFocusLost = true;
    private JComboBox<E> comboBox;
    private JPopupMenu popupMenu;
    private ComboPopup popup;
    private JButton arrowButton;
    private final AutoCompleteComboBoxModel comboBoxModel;
    private final ListCellRenderer<Object> renderer;
    private final EventList<E> items;
    private final FilterList<E> filteredItems;
    private final EventList<E> firstItem;
    private final CompositeList<E> allItemsFiltered;
    private final CompositeList<E> allItemsUnfiltered;
    private final Format format;
    private final TextMatcherEditor<E> filterMatcherEditor;
    private FormatComboBoxEditor comboBoxEditor;
    private JTextField comboBoxEditorComponent;
    private AbstractDocument document;
    private final AutoCompleteFilter documentFilter = new AutoCompleteFilter();
    private String prefix = "";
    private Matcher<String> filterMatcher = Matchers.trueMatcher();
    private boolean isFiltering = false;
    private final boolean isTableCellEditor;
    private ArrowButtonMouseListener arrowButtonMouseListener;
    private final ListDataListener listDataHandler = new ListDataHandler();
    private final PopupMenuListener popupSizerHandler = new PopupSizer();
    private ComboBoxPopupLocationFix popupLocationFix;
    private final MouseListener popupMouseHandler = new PopupMouseHandler();
    private final KeyListener strictModeBackspaceHandler = new AutoCompleteKeyHandler();
    private final FocusListener selectTextOnFocusGainHandler = new ComboBoxEditorFocusHandler();
    private final DocumentWatcher documentWatcher = new DocumentWatcher();
    private final ModelWatcher modelWatcher = new ModelWatcher();
    private final UIWatcher uiWatcher = new UIWatcher();
    private boolean doNotPostProcessDocumentChanges = false;
    private boolean doNotFilter = false;
    private boolean doNotChangeDocument = false;
    private boolean doNotAutoComplete = false;
    private boolean doNotTogglePopup;
    private boolean doNotClearFilterOnPopupHide = false;
    private final boolean originalComboBoxEditable;
    private ComboBoxModel<E> originalModel;
    private ListCellRenderer<? super E> originalRenderer;
    private Action originalSelectNextAction;
    private Action originalSelectPreviousAction;
    private Action originalSelectNext2Action;
    private Action originalSelectPrevious2Action;
    private Action originalAquaSelectNextAction;
    private Action originalAquaSelectPreviousAction;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AutoCompleteSupport(JComboBox<E> comboBox, EventList<E> items, TextFilterator<? super E> filterator, Format format) {
        this.comboBox = comboBox;
        this.originalComboBoxEditable = comboBox.isEditable();
        this.originalModel = comboBox.getModel();
        this.items = items;
        this.format = format;
        boolean defaultRendererInstalled = comboBox.getRenderer() instanceof UIResource;
        this.renderer = format != null && defaultRendererInstalled ? new StringFunctionRenderer() : null;
        this.isTableCellEditor = Boolean.TRUE.equals(comboBox.getClientProperty("JComboBox.isTableCellEditor"));
        this.doNotTogglePopup = !this.isTableCellEditor;
        items.getReadWriteLock().readLock().lock();
        try {
            this.filterMatcherEditor = new TextMatcherEditor(filterator == null ? new DefaultTextFilterator() : filterator);
            this.filterMatcherEditor.setMode(1);
            this.filteredItems = new FilterList<E>(items, this.filterMatcherEditor);
            this.firstItem = new BasicEventList(items.getPublisher(), items.getReadWriteLock());
            this.allItemsFiltered = new CompositeList(items.getPublisher(), items.getReadWriteLock());
            this.allItemsFiltered.addMemberList(this.firstItem);
            this.allItemsFiltered.addMemberList(this.filteredItems);
            this.comboBoxModel = new AutoCompleteComboBoxModel(this.allItemsFiltered);
            this.allItemsUnfiltered = new CompositeList(items.getPublisher(), items.getReadWriteLock());
            this.allItemsUnfiltered.addMemberList(this.firstItem);
            this.allItemsUnfiltered.addMemberList(this.items);
        }
        finally {
            items.getReadWriteLock().readLock().unlock();
        }
        this.comboBox.setModel(this.comboBoxModel);
        this.comboBox.setEditable(true);
        this.decorateCurrentUI();
        this.comboBox.addPropertyChangeListener("UI", this.uiWatcher);
        this.comboBox.addPropertyChangeListener("model", this.modelWatcher);
        this.comboBoxEditorComponent.addPropertyChangeListener("document", this.documentWatcher);
    }

    private static void checkAccessThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("AutoCompleteSupport must be accessed from the Swing Event Dispatch Thread, but was called on Thread \"" + Thread.currentThread().getName() + "\"");
        }
    }

    private static ActionListener[] unregisterAllActionListeners(JComboBox<?> comboBox) {
        ActionListener[] listeners = comboBox.getActionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            comboBox.removeActionListener(listeners[i]);
        }
        return listeners;
    }

    private static void registerAllActionListeners(JComboBox<?> comboBox, ActionListener[] listeners) {
        for (int i = 0; i < listeners.length; ++i) {
            comboBox.addActionListener(listeners[i]);
        }
    }

    private static JButton findArrowButton(JComboBox<?> c) {
        int n = c.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component comp = c.getComponent(i);
            if (!(comp instanceof JButton)) continue;
            return (JButton)comp;
        }
        return null;
    }

    private void decorateCurrentUI() {
        this.originalRenderer = this.comboBox.getRenderer();
        this.popupMenu = (JPopupMenu)this.comboBox.getUI().getAccessibleChild(this.comboBox, 0);
        this.popup = (ComboPopup)((Object)this.popupMenu);
        this.arrowButton = AutoCompleteSupport.findArrowButton(this.comboBox);
        if (this.arrowButton != null) {
            this.arrowButton.removeMouseListener(this.popup.getMouseListener());
            this.arrowButtonMouseListener = new ArrowButtonMouseListener(this.popup.getMouseListener());
            this.arrowButton.addMouseListener(this.arrowButtonMouseListener);
        }
        this.comboBox.getModel().addListDataListener(this.listDataHandler);
        this.popupMenu.addPopupMenuListener(this.popupSizerHandler);
        this.popupLocationFix = ComboBoxPopupLocationFix.install(this.comboBox);
        this.popup.getList().addMouseListener(this.popupMouseHandler);
        ActionMap actionMap = this.comboBox.getActionMap();
        this.originalSelectNextAction = actionMap.get("selectNext");
        this.originalSelectPreviousAction = actionMap.get("selectPrevious");
        this.originalSelectNext2Action = actionMap.get("selectNext2");
        this.originalSelectPrevious2Action = actionMap.get("selectPrevious2");
        this.originalAquaSelectNextAction = actionMap.get("aquaSelectNext");
        this.originalAquaSelectPreviousAction = actionMap.get("aquaSelectPrevious");
        MoveAction upAction = new MoveAction(-1);
        MoveAction downAction = new MoveAction(1);
        actionMap.put("selectPrevious", upAction);
        actionMap.put("selectNext", downAction);
        actionMap.put("selectPrevious2", upAction);
        actionMap.put("selectNext2", downAction);
        actionMap.put("aquaSelectPrevious", upAction);
        actionMap.put("aquaSelectNext", downAction);
        this.comboBoxEditor = new FormatComboBoxEditor(this.comboBox.getEditor());
        this.comboBox.setEditor(this.comboBoxEditor);
        this.comboBoxEditorComponent = (JTextField)this.comboBox.getEditor().getEditorComponent();
        this.document = (AbstractDocument)this.comboBoxEditorComponent.getDocument();
        this.document.setDocumentFilter(this.documentFilter);
        if (this.renderer != null) {
            this.comboBox.setRenderer(this.renderer);
        }
        this.comboBoxEditorComponent.addKeyListener(this.strictModeBackspaceHandler);
        this.comboBoxEditorComponent.addFocusListener(this.selectTextOnFocusGainHandler);
    }

    private void undecorateOriginalUI() {
        if (this.arrowButton != null) {
            this.arrowButton.removeMouseListener(this.arrowButtonMouseListener);
            this.arrowButton.addMouseListener(this.arrowButtonMouseListener.getDecorated());
        }
        this.comboBox.getModel().removeListDataListener(this.listDataHandler);
        this.document.setDocumentFilter(null);
        if (this.comboBox.getEditor() == this.comboBoxEditor) {
            this.comboBox.setEditor(this.comboBoxEditor.getDelegate());
        }
        this.popupMenu.removePopupMenuListener(this.popupSizerHandler);
        this.popupLocationFix.uninstall();
        this.popup.getList().removeMouseListener(this.popupMouseHandler);
        ActionMap actionMap = this.comboBox.getActionMap();
        actionMap.put("selectPrevious", this.originalSelectPreviousAction);
        actionMap.put("selectNext", this.originalSelectNextAction);
        actionMap.put("selectPrevious2", this.originalSelectPrevious2Action);
        actionMap.put("selectNext2", this.originalSelectNext2Action);
        actionMap.put("aquaSelectPrevious", this.originalAquaSelectPreviousAction);
        actionMap.put("aquaSelectNext", this.originalAquaSelectNextAction);
        this.comboBoxEditorComponent.removeKeyListener(this.strictModeBackspaceHandler);
        this.comboBoxEditorComponent.removeFocusListener(this.selectTextOnFocusGainHandler);
        if (this.comboBox.getRenderer() == this.renderer) {
            this.comboBox.setRenderer(this.originalRenderer);
        }
        this.originalRenderer = null;
        this.comboBoxEditor = null;
        this.comboBoxEditorComponent = null;
        this.document = null;
        this.popupMenu = null;
        this.popup = null;
        this.arrowButton = null;
    }

    public static <E> AutoCompleteSupport<E> install(JComboBox<E> comboBox, EventList<E> items) {
        return AutoCompleteSupport.install(comboBox, items, null);
    }

    public static <E> AutoCompleteSupport<E> install(JComboBox<E> comboBox, EventList<E> items, TextFilterator<? super E> filterator) {
        return AutoCompleteSupport.install(comboBox, items, filterator, null);
    }

    public static <E> AutoCompleteSupport<E> install(JComboBox<E> comboBox, EventList<E> items, TextFilterator<? super E> filterator, Format format) {
        AutoCompleteSupport.checkAccessThread();
        Component editorComponent = comboBox.getEditor().getEditorComponent();
        if (!(editorComponent instanceof JTextField)) {
            throw new IllegalArgumentException("comboBox must use a JTextField as its editor component");
        }
        if (!(((JTextField)editorComponent).getDocument() instanceof AbstractDocument)) {
            throw new IllegalArgumentException("comboBox must use a JTextField backed by an AbstractDocument as its editor component");
        }
        if (comboBox.getModel().getClass() == AutoCompleteComboBoxModel.class) {
            throw new IllegalArgumentException("comboBox is already configured for autocompletion");
        }
        return new AutoCompleteSupport<E>(comboBox, items, filterator, format);
    }

    private void throwIllegalStateException(String message) {
        String exceptionMsg = message + "\n" + "In order for AutoCompleteSupport to continue to " + "work, the following invariants must be maintained after " + "AutoCompleteSupport.install() has been called:\n" + "* the ComboBoxModel may not be removed\n" + "* the AbstractDocument behind the JTextField can be changed but must be changed to some subclass of AbstractDocument\n" + "* the DocumentFilter on the AbstractDocument behind the JTextField may not be removed\n";
        this.uninstall();
        throw new IllegalStateException(exceptionMsg);
    }

    private String convertToString(Object comboBoxElement) {
        if (comboBoxElement == NOT_FOUND) {
            return "NOT_FOUND";
        }
        if (this.format != null) {
            return this.format.format(comboBoxElement);
        }
        return comboBoxElement == null ? "" : comboBoxElement.toString();
    }

    public JComboBox<E> getComboBox() {
        return this.comboBox;
    }

    public TextFilterator<? super E> getTextFilterator() {
        return this.filterMatcherEditor.getFilterator();
    }

    public EventList<E> getItemList() {
        return this.filteredItems;
    }

    public boolean getCorrectsCase() {
        return this.correctsCase;
    }

    public void setCorrectsCase(boolean correctCase) {
        AutoCompleteSupport.checkAccessThread();
        this.correctsCase = correctCase;
    }

    public boolean isStrict() {
        return this.strict;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrict(boolean strict) {
        AutoCompleteSupport.checkAccessThread();
        if (this.strict == strict) {
            return;
        }
        this.strict = strict;
        if (strict) {
            String currentText = this.comboBoxEditorComponent.getText();
            Object currentItem = this.findAutoCompleteTerm(currentText);
            String currentItemText = this.convertToString(currentItem);
            boolean itemMatches = currentItem == this.comboBox.getSelectedItem();
            boolean textMatches = GlazedListsImpl.equal(currentItemText, currentText);
            if (currentItem == NOT_FOUND && !this.allItemsUnfiltered.isEmpty()) {
                currentItem = this.allItemsUnfiltered.get(0);
                currentItemText = this.convertToString(currentItem);
                itemMatches = currentItem == this.comboBox.getSelectedItem();
                textMatches = GlazedListsImpl.equal(currentItemText, currentText);
            }
            this.applyFilter("");
            this.doNotPostProcessDocumentChanges = true;
            try {
                if (!textMatches) {
                    this.comboBoxEditorComponent.setText(currentItemText);
                }
                if (!itemMatches || this.comboBox.getSelectedIndex() == -1) {
                    this.comboBox.setSelectedItem(currentItem);
                }
            }
            finally {
                this.doNotPostProcessDocumentChanges = false;
            }
        }
    }

    public boolean getBeepOnStrictViolation() {
        return this.beepOnStrictViolation;
    }

    public void setBeepOnStrictViolation(boolean beepOnStrictViolation) {
        AutoCompleteSupport.checkAccessThread();
        this.beepOnStrictViolation = beepOnStrictViolation;
    }

    public boolean getSelectsTextOnFocusGain() {
        return this.selectsTextOnFocusGain;
    }

    public void setSelectsTextOnFocusGain(boolean selectsTextOnFocusGain) {
        AutoCompleteSupport.checkAccessThread();
        this.selectsTextOnFocusGain = selectsTextOnFocusGain;
    }

    public boolean getHidesPopupOnFocusLost() {
        return this.hidesPopupOnFocusLost;
    }

    public void setHidesPopupOnFocusLost(boolean hidesPopupOnFocusLost) {
        AutoCompleteSupport.checkAccessThread();
        this.hidesPopupOnFocusLost = hidesPopupOnFocusLost;
    }

    public int getFilterMode() {
        return this.filterMatcherEditor.getMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilterMode(int mode) {
        AutoCompleteSupport.checkAccessThread();
        this.doNotChangeDocument = true;
        try {
            this.filterMatcherEditor.setMode(mode);
        }
        finally {
            this.doNotChangeDocument = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTextMatchingStrategy(Object strategy) {
        AutoCompleteSupport.checkAccessThread();
        this.doNotChangeDocument = true;
        try {
            this.filterMatcherEditor.setStrategy(strategy);
        }
        finally {
            this.doNotChangeDocument = false;
        }
    }

    public Object getTextMatchingStrategy() {
        return this.filterMatcherEditor.getStrategy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFirstItem(E item) {
        AutoCompleteSupport.checkAccessThread();
        this.doNotChangeDocument = true;
        this.firstItem.getReadWriteLock().writeLock().lock();
        try {
            if (this.firstItem.isEmpty()) {
                this.firstItem.add(item);
            } else {
                this.firstItem.set(0, item);
            }
        }
        finally {
            this.firstItem.getReadWriteLock().writeLock().unlock();
            this.doNotChangeDocument = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E getFirstItem() {
        this.firstItem.getReadWriteLock().readLock().lock();
        try {
            E e = this.firstItem.isEmpty() ? null : (E)this.firstItem.get(0);
            return e;
        }
        finally {
            this.firstItem.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E removeFirstItem() {
        AutoCompleteSupport.checkAccessThread();
        this.doNotChangeDocument = true;
        this.firstItem.getReadWriteLock().writeLock().lock();
        try {
            E e = this.firstItem.isEmpty() ? null : (E)this.firstItem.remove(0);
            return e;
        }
        finally {
            this.firstItem.getReadWriteLock().writeLock().unlock();
            this.doNotChangeDocument = false;
        }
    }

    public boolean isInstalled() {
        AutoCompleteSupport.checkAccessThread();
        return this.comboBox != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstall() {
        AutoCompleteSupport.checkAccessThread();
        if (this.comboBox == null) {
            throw new IllegalStateException("This AutoCompleteSupport has already been uninstalled");
        }
        this.items.getReadWriteLock().readLock().lock();
        try {
            this.comboBox.removePropertyChangeListener("UI", this.uiWatcher);
            this.comboBox.removePropertyChangeListener("model", this.modelWatcher);
            this.comboBoxEditorComponent.removePropertyChangeListener("document", this.documentWatcher);
            this.undecorateOriginalUI();
            this.comboBox.setModel(this.originalModel);
            this.originalModel = null;
            this.comboBox.setEditable(this.originalComboBoxEditable);
            this.comboBoxModel.dispose();
            this.allItemsFiltered.dispose();
            this.allItemsUnfiltered.dispose();
            this.filteredItems.dispose();
            this.comboBox = null;
        }
        finally {
            this.items.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyFilter(String newFilter) {
        if (this.doNotFilter) {
            return;
        }
        this.doNotChangeDocument = true;
        ActionListener[] listeners = AutoCompleteSupport.unregisterAllActionListeners(this.comboBox);
        this.isFiltering = true;
        try {
            this.filterMatcherEditor.setFilterText(new String[]{newFilter});
        }
        finally {
            this.isFiltering = false;
            AutoCompleteSupport.registerAllActionListeners(this.comboBox, listeners);
            this.doNotChangeDocument = false;
        }
    }

    private void updateFilter() {
        this.prefix = this.comboBoxEditorComponent.getText();
        this.filterMatcher = this.prefix.length() == 0 ? Matchers.trueMatcher() : new TextMatcher<String>(new SearchTerm[]{new SearchTerm(this.prefix)}, GlazedLists.toStringTextFilterator(), 1, this.getTextMatchingStrategy());
    }

    private void togglePopup() {
        if (this.doNotTogglePopup) {
            return;
        }
        if (this.comboBoxModel.getSize() == 0) {
            this.comboBox.hidePopup();
        } else if (this.comboBox.isShowing() && !this.comboBox.isPopupVisible() && this.comboBoxEditorComponent.hasFocus()) {
            this.comboBox.showPopup();
        }
    }

    private Object findAutoCompleteTerm(String value) {
        boolean prefixIsEmpty = "".equals(value);
        TextMatcher<String> valueMatcher = new TextMatcher<String>(new SearchTerm[]{new SearchTerm(value)}, GlazedLists.toStringTextFilterator(), 1, this.getTextMatchingStrategy());
        Object partialMatchItem = NOT_FOUND;
        int n = this.allItemsUnfiltered.size();
        for (int i = 0; i < n; ++i) {
            Object item = this.allItemsUnfiltered.get(i);
            String itemString = this.convertToString(item);
            if (value.equals(itemString)) {
                return item;
            }
            if (partialMatchItem != NOT_FOUND || !(prefixIsEmpty ? "".equals(itemString) : valueMatcher.matches(itemString))) continue;
            partialMatchItem = item;
        }
        return partialMatchItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectPossibleValue(int index) {
        String newSelection;
        block18: {
            boolean validIndex;
            if (this.isStrict()) {
                if (index < 0) {
                    index = this.comboBox.getModel().getSize() - 1;
                }
                if (index > this.comboBox.getModel().getSize() - 1) {
                    index = 0;
                }
            } else if (index == -2) {
                index = this.comboBox.getModel().getSize() - 1;
            }
            boolean bl = validIndex = index >= 0 && index < this.comboBox.getModel().getSize();
            if (!validIndex) {
                index = -1;
            }
            this.doNotPostProcessDocumentChanges = true;
            try {
                if (this.isTableCellEditor) {
                    ActionListener[] listeners = AutoCompleteSupport.unregisterAllActionListeners(this.comboBox);
                    try {
                        this.comboBox.setSelectedIndex(index);
                    }
                    finally {
                        AutoCompleteSupport.registerAllActionListeners(this.comboBox, listeners);
                    }
                } else {
                    this.comboBox.setSelectedIndex(index);
                }
                if (validIndex) break block18;
                this.comboBoxEditorComponent.setText(this.prefix);
                this.doNotClearFilterOnPopupHide = true;
                try {
                    this.comboBox.hidePopup();
                }
                finally {
                    this.doNotClearFilterOnPopupHide = false;
                }
                this.comboBox.showPopup();
            }
            finally {
                this.doNotPostProcessDocumentChanges = false;
            }
        }
        if (this.filterMatcher.matches(newSelection = this.comboBoxEditorComponent.getText())) {
            this.comboBoxEditorComponent.select(this.prefix.length(), newSelection.length());
        }
    }

    public static <E> AutoCompleteCellEditor<E> createTableCellEditor(TableFormat<E> tableFormat, EventList<E> tableData, int columnIndex) {
        return AutoCompleteSupport.createTableCellEditor(GlazedLists.comparableComparator(), tableFormat, tableData, columnIndex);
    }

    public static <E> AutoCompleteCellEditor<E> createTableCellEditor(Comparator uniqueComparator, TableFormat<E> tableFormat, EventList<E> tableData, int columnIndex) {
        TableColumnValueFunction<E> columnValueFunction = new TableColumnValueFunction<E>(tableFormat, columnIndex);
        FunctionList allColumnValues = new FunctionList(tableData, columnValueFunction);
        UniqueList uniqueColumnValues = new UniqueList(allColumnValues, uniqueComparator);
        return AutoCompleteSupport.createTableCellEditor(uniqueColumnValues);
    }

    public static <E> AutoCompleteCellEditor<E> createTableCellEditor(EventList<E> source) {
        TableCellComboBox comboBox = new TableCellComboBox();
        comboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        AutoCompleteSupport autoCompleteSupport = AutoCompleteSupport.install(comboBox, source);
        autoCompleteSupport.setSelectsTextOnFocusGain(false);
        AutoCompleteCellEditor cellEditor = new AutoCompleteCellEditor(autoCompleteSupport);
        cellEditor.setClickCountToStart(2);
        return cellEditor;
    }

    private class ArrowButtonMouseListener
    implements MouseListener {
        private final MouseListener decorated;

        public ArrowButtonMouseListener(MouseListener decorated) {
            this.decorated = decorated;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            AutoCompleteSupport.this.applyFilter("");
            this.decorated.mousePressed(e);
        }

        public MouseListener getDecorated() {
            return this.decorated;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.decorated.mouseClicked(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.decorated.mouseReleased(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.decorated.mouseEntered(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.decorated.mouseExited(e);
        }
    }

    public static class AutoCompleteCellEditor<E>
    extends DefaultCellEditor {
        private final AutoCompleteSupport<E> autoCompleteSupport;

        public AutoCompleteCellEditor(AutoCompleteSupport<E> autoCompleteSupport) {
            super(autoCompleteSupport.getComboBox());
            this.autoCompleteSupport = autoCompleteSupport;
        }

        public AutoCompleteSupport<E> getAutoCompleteSupport() {
            return this.autoCompleteSupport;
        }
    }

    private class AutoCompleteComboBoxModel
    extends EventComboBoxModel<E> {
        public AutoCompleteComboBoxModel(EventList<E> source) {
            super(source);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSelectedItem(Object selected) {
            AutoCompleteSupport.this.doNotFilter = true;
            AutoCompleteSupport.this.doNotAutoComplete = true;
            ActionListener[] listeners = AutoCompleteSupport.unregisterAllActionListeners(AutoCompleteSupport.this.comboBox);
            try {
                super.setSelectedItem(selected);
                if (AutoCompleteSupport.this.comboBoxEditorComponent != null) {
                    int caretPos = AutoCompleteSupport.this.comboBoxEditorComponent.getCaretPosition();
                    AutoCompleteSupport.this.comboBoxEditorComponent.select(caretPos, caretPos);
                }
            }
            finally {
                AutoCompleteSupport.registerAllActionListeners(AutoCompleteSupport.this.comboBox, listeners);
                AutoCompleteSupport.this.doNotFilter = false;
                AutoCompleteSupport.this.doNotAutoComplete = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void listChanged(ListEvent<E> listChanges) {
            AutoCompleteSupport.this.doNotChangeDocument = true;
            try {
                super.listChanged(listChanges);
            }
            finally {
                AutoCompleteSupport.this.doNotChangeDocument = false;
            }
        }
    }

    private class AutoCompleteFilter
    extends DocumentFilter {
        private AutoCompleteFilter() {
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int offset, int length, String string, AttributeSet attributeSet) throws BadLocationException {
            boolean isReplacingAllText;
            if (AutoCompleteSupport.this.doNotChangeDocument) {
                return;
            }
            String valueBeforeEdit = AutoCompleteSupport.this.comboBoxEditorComponent.getText();
            int selectionStart = AutoCompleteSupport.this.comboBoxEditorComponent.getSelectionStart();
            int selectionEnd = AutoCompleteSupport.this.comboBoxEditorComponent.getSelectionEnd();
            boolean bl = isReplacingAllText = offset == 0 && AutoCompleteSupport.this.document.getLength() == length;
            if (isReplacingAllText && valueBeforeEdit.equals(string)) {
                return;
            }
            super.replace(filterBypass, offset, length, string, attributeSet);
            this.postProcessDocumentChange(filterBypass, attributeSet, valueBeforeEdit, selectionStart, selectionEnd, true);
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int offset, String string, AttributeSet attributeSet) throws BadLocationException {
            if (AutoCompleteSupport.this.doNotChangeDocument) {
                return;
            }
            String valueBeforeEdit = AutoCompleteSupport.this.comboBoxEditorComponent.getText();
            int selectionStart = AutoCompleteSupport.this.comboBoxEditorComponent.getSelectionStart();
            int selectionEnd = AutoCompleteSupport.this.comboBoxEditorComponent.getSelectionEnd();
            super.insertString(filterBypass, offset, string, attributeSet);
            this.postProcessDocumentChange(filterBypass, attributeSet, valueBeforeEdit, selectionStart, selectionEnd, true);
        }

        @Override
        public void remove(DocumentFilter.FilterBypass filterBypass, int offset, int length) throws BadLocationException {
            if (AutoCompleteSupport.this.doNotChangeDocument) {
                return;
            }
            String valueBeforeEdit = AutoCompleteSupport.this.comboBoxEditorComponent.getText();
            int selectionStart = AutoCompleteSupport.this.comboBoxEditorComponent.getSelectionStart();
            int selectionEnd = AutoCompleteSupport.this.comboBoxEditorComponent.getSelectionEnd();
            super.remove(filterBypass, offset, length);
            this.postProcessDocumentChange(filterBypass, null, valueBeforeEdit, selectionStart, selectionEnd, AutoCompleteSupport.this.isStrict());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void postProcessDocumentChange(DocumentFilter.FilterBypass filterBypass, AttributeSet attributeSet, String valueBeforeEdit, int selectionStart, int selectionEnd, boolean allowPartialAutoCompletionTerm) throws BadLocationException {
            if (AutoCompleteSupport.this.doNotPostProcessDocumentChanges) {
                return;
            }
            String valueAfterEdit = AutoCompleteSupport.this.comboBoxEditorComponent.getText();
            if (AutoCompleteSupport.this.isStrict() && AutoCompleteSupport.this.findAutoCompleteTerm(valueAfterEdit) == NOT_FOUND && !AutoCompleteSupport.this.allItemsUnfiltered.isEmpty()) {
                if (AutoCompleteSupport.this.getBeepOnStrictViolation()) {
                    UIManager.getLookAndFeel().provideErrorFeedback(AutoCompleteSupport.this.comboBoxEditorComponent);
                }
                AutoCompleteSupport.this.doNotPostProcessDocumentChanges = true;
                try {
                    AutoCompleteSupport.this.comboBoxEditorComponent.setText(valueBeforeEdit);
                }
                finally {
                    AutoCompleteSupport.this.doNotPostProcessDocumentChanges = false;
                }
                AutoCompleteSupport.this.comboBoxEditorComponent.select(selectionStart, selectionEnd);
                return;
            }
            Object selectedItemBeforeEdit = AutoCompleteSupport.this.comboBox.getSelectedItem();
            AutoCompleteSupport.this.updateFilter();
            AutoCompleteSupport.this.applyFilter(AutoCompleteSupport.this.prefix);
            this.selectAutoCompleteTerm(filterBypass, attributeSet, selectedItemBeforeEdit, allowPartialAutoCompletionTerm);
            AutoCompleteSupport.this.togglePopup();
        }

        private void selectAutoCompleteTerm(DocumentFilter.FilterBypass filterBypass, AttributeSet attributeSet, Object selectedItemBeforeEdit, boolean allowPartialAutoCompletionTerm) throws BadLocationException {
            if (AutoCompleteSupport.this.doNotAutoComplete) {
                return;
            }
            boolean prefixIsEmpty = "".equals(AutoCompleteSupport.this.prefix);
            int originalCaretPosition = AutoCompleteSupport.this.comboBoxEditorComponent.getCaretPosition();
            boolean autoCompleteTermIsExactMatch = false;
            int n = AutoCompleteSupport.this.comboBoxModel.getSize();
            for (int i = 0; i < n; ++i) {
                String itemString = AutoCompleteSupport.this.convertToString(AutoCompleteSupport.this.comboBoxModel.getElementAt(i));
                if (prefixIsEmpty ? !"".equals(itemString) : !AutoCompleteSupport.this.filterMatcher.matches(itemString)) continue;
                int matchIndex = i;
                String matchString = itemString;
                for (int j = i; j < n; ++j) {
                    itemString = AutoCompleteSupport.this.convertToString(AutoCompleteSupport.this.comboBoxModel.getElementAt(j));
                    if (!AutoCompleteSupport.this.prefix.equals(itemString)) continue;
                    matchIndex = j;
                    matchString = itemString;
                    autoCompleteTermIsExactMatch = true;
                    break;
                }
                if (!allowPartialAutoCompletionTerm && !AutoCompleteSupport.this.prefix.equals(itemString)) {
                    return;
                }
                if (AutoCompleteSupport.this.getCorrectsCase() || AutoCompleteSupport.this.isStrict()) {
                    filterBypass.replace(0, AutoCompleteSupport.this.prefix.length(), matchString, attributeSet);
                } else {
                    String itemSuffix = matchString.substring(AutoCompleteSupport.this.prefix.length());
                    filterBypass.insertString(AutoCompleteSupport.this.prefix.length(), itemSuffix, attributeSet);
                }
                boolean silently = AutoCompleteSupport.this.isTableCellEditor || GlazedListsImpl.equal(selectedItemBeforeEdit, matchString);
                this.selectItem(matchIndex, silently);
                if (autoCompleteTermIsExactMatch) {
                    AutoCompleteSupport.this.comboBoxEditorComponent.setCaretPosition(originalCaretPosition);
                } else {
                    AutoCompleteSupport.this.comboBoxEditorComponent.select(AutoCompleteSupport.this.prefix.length(), AutoCompleteSupport.this.document.getLength());
                }
                return;
            }
            boolean silently = AutoCompleteSupport.this.isTableCellEditor || selectedItemBeforeEdit == null;
            this.selectItem(-1, silently);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void selectItem(int index, boolean silently) {
            Object valueToSelect;
            Object v0 = valueToSelect = index == -1 ? null : AutoCompleteSupport.this.comboBoxModel.getElementAt(index);
            if (GlazedListsImpl.equal(AutoCompleteSupport.this.comboBoxModel.getSelectedItem(), valueToSelect)) {
                return;
            }
            AutoCompleteSupport.this.doNotChangeDocument = true;
            try {
                if (silently) {
                    AutoCompleteSupport.this.comboBoxModel.setSelectedItem(valueToSelect);
                } else {
                    AutoCompleteSupport.this.comboBox.setSelectedItem(valueToSelect);
                }
            }
            finally {
                AutoCompleteSupport.this.doNotChangeDocument = false;
            }
        }
    }

    private class AutoCompleteKeyHandler
    extends KeyAdapter {
        private ActionListener[] actionListeners;

        private AutoCompleteKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (!AutoCompleteSupport.this.isTableCellEditor) {
                AutoCompleteSupport.this.doNotTogglePopup = false;
            }
            if (e.getKeyChar() == '\n') {
                AutoCompleteSupport.this.doNotChangeDocument = true;
                this.actionListeners = AutoCompleteSupport.unregisterAllActionListeners(AutoCompleteSupport.this.comboBox);
            }
            if (this.isTrigger(e)) {
                AutoCompleteSupport.this.doNotChangeDocument = true;
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (this.isTrigger(e)) {
                if (AutoCompleteSupport.this.comboBoxEditorComponent.getText().length() == 0) {
                    return;
                }
                int selectionStart = Math.min(AutoCompleteSupport.this.comboBoxEditorComponent.getSelectionStart(), AutoCompleteSupport.this.comboBoxEditorComponent.getSelectionEnd());
                if (selectionStart == 0) {
                    if (AutoCompleteSupport.this.getBeepOnStrictViolation()) {
                        UIManager.getLookAndFeel().provideErrorFeedback(AutoCompleteSupport.this.comboBoxEditorComponent);
                    }
                    return;
                }
                AutoCompleteSupport.this.comboBoxEditorComponent.setCaretPosition(AutoCompleteSupport.this.comboBoxEditorComponent.getText().length());
                AutoCompleteSupport.this.comboBoxEditorComponent.moveCaretPosition(--selectionStart);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (this.isTrigger(e)) {
                AutoCompleteSupport.this.doNotChangeDocument = false;
            }
            if (e.getKeyChar() == '\n') {
                AutoCompleteSupport.this.updateFilter();
                if (this.actionListeners != null) {
                    AutoCompleteSupport.registerAllActionListeners(AutoCompleteSupport.this.comboBox, this.actionListeners);
                    AutoCompleteSupport.this.comboBox.actionPerformed(new ActionEvent(e.getSource(), e.getID(), null));
                }
                this.actionListeners = null;
                AutoCompleteSupport.this.doNotChangeDocument = false;
            }
            if (!AutoCompleteSupport.this.isTableCellEditor) {
                AutoCompleteSupport.this.doNotTogglePopup = true;
            }
        }

        private boolean isTrigger(KeyEvent e) {
            return AutoCompleteSupport.this.isStrict() && e.getKeyChar() == '\b';
        }
    }

    private class ComboBoxEditorFocusHandler
    extends FocusAdapter {
        private ComboBoxEditorFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (AutoCompleteSupport.this.getSelectsTextOnFocusGain()) {
                AutoCompleteSupport.this.comboBoxEditorComponent.select(0, AutoCompleteSupport.this.comboBoxEditorComponent.getText().length());
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (AutoCompleteSupport.this.comboBox.isPopupVisible() && AutoCompleteSupport.this.getHidesPopupOnFocusLost()) {
                AutoCompleteSupport.this.comboBox.setPopupVisible(false);
            }
        }
    }

    class DefaultTextFilterator
    implements TextFilterator<E> {
        DefaultTextFilterator() {
        }

        @Override
        public void getFilterStrings(List<String> baseList, E element) {
            baseList.add(AutoCompleteSupport.this.convertToString(element));
        }
    }

    private class DocumentWatcher
    implements PropertyChangeListener {
        private DocumentWatcher() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Document newDocument = (Document)evt.getNewValue();
            if (!(newDocument instanceof AbstractDocument)) {
                AutoCompleteSupport.this.throwIllegalStateException("The Document behind the JTextField was changed to no longer be an AbstractDocument. It was changed to: " + newDocument);
            }
            AutoCompleteSupport.this.document.setDocumentFilter(null);
            AutoCompleteSupport.this.document = (AbstractDocument)newDocument;
            AutoCompleteSupport.this.document.setDocumentFilter(AutoCompleteSupport.this.documentFilter);
        }
    }

    private class FormatComboBoxEditor
    implements ComboBoxEditor,
    UIResource {
        private final ComboBoxEditor delegate;
        private Object oldValue;

        public FormatComboBoxEditor(ComboBoxEditor delegate) {
            this.delegate = delegate;
        }

        public ComboBoxEditor getDelegate() {
            return this.delegate;
        }

        @Override
        public void setItem(Object anObject) {
            this.oldValue = anObject;
            ((JTextField)this.getEditorComponent()).setText(AutoCompleteSupport.this.convertToString(anObject));
        }

        @Override
        public Object getItem() {
            String currentString;
            String oldValueString = AutoCompleteSupport.this.convertToString(this.oldValue);
            if (GlazedListsImpl.equal(oldValueString, currentString = ((JTextField)this.getEditorComponent()).getText())) {
                return this.oldValue;
            }
            if (AutoCompleteSupport.this.format != null) {
                return AutoCompleteSupport.this.format.parseObject(currentString, PARSE_POSITION);
            }
            if (this.oldValue != null && !(this.oldValue instanceof String)) {
                try {
                    Method method = this.oldValue.getClass().getMethod("valueOf", VALUE_OF_SIGNATURE);
                    return method.invoke(this.oldValue, currentString);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return currentString;
        }

        @Override
        public Component getEditorComponent() {
            return this.delegate.getEditorComponent();
        }

        @Override
        public void selectAll() {
            this.delegate.selectAll();
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.delegate.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.delegate.removeActionListener(l);
        }
    }

    private class ListDataHandler
    implements ListDataListener {
        private int previousItemCount = -1;
        private final Runnable checkStrictModeInvariantRunnable = new CheckStrictModeInvariantRunnable();

        private ListDataHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void contentsChanged(ListDataEvent e) {
            boolean userSelectedNewItem;
            int newItemCount = AutoCompleteSupport.this.comboBox.getItemCount();
            if (this.previousItemCount != newItemCount) {
                int maxPopupItemCount = AutoCompleteSupport.this.comboBox.getMaximumRowCount();
                if (AutoCompleteSupport.this.popupMenu.isShowing()) {
                    if (AutoCompleteSupport.this.comboBox.isShowing()) {
                        if (newItemCount < maxPopupItemCount || this.previousItemCount < maxPopupItemCount) {
                            AutoCompleteSupport.this.doNotClearFilterOnPopupHide = true;
                            try {
                                AutoCompleteSupport.this.comboBox.hidePopup();
                            }
                            finally {
                                AutoCompleteSupport.this.doNotClearFilterOnPopupHide = false;
                            }
                            AutoCompleteSupport.this.comboBox.showPopup();
                        }
                    } else {
                        AutoCompleteSupport.this.comboBox.hidePopup();
                    }
                }
                this.previousItemCount = newItemCount;
            }
            boolean bl = userSelectedNewItem = e.getIndex0() == -1 || e.getIndex1() == -1;
            if (AutoCompleteSupport.this.isStrict() && !userSelectedNewItem && !AutoCompleteSupport.this.isFiltering) {
                SwingUtilities.invokeLater(this.checkStrictModeInvariantRunnable);
            }
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.contentsChanged(e);
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.contentsChanged(e);
        }

        private class CheckStrictModeInvariantRunnable
        implements Runnable {
            private CheckStrictModeInvariantRunnable() {
            }

            @Override
            public void run() {
                Object item;
                String itemText;
                String currentText;
                JTextField editor = AutoCompleteSupport.this.comboBoxEditorComponent;
                if (editor != null && !(currentText = editor.getText()).equals(itemText = AutoCompleteSupport.this.convertToString(item = AutoCompleteSupport.this.findAutoCompleteTerm(currentText)))) {
                    if (item == NOT_FOUND && !AutoCompleteSupport.this.allItemsUnfiltered.isEmpty()) {
                        itemText = AutoCompleteSupport.this.convertToString(AutoCompleteSupport.this.allItemsUnfiltered.get(0));
                    }
                    editor.setText(itemText);
                }
            }
        }
    }

    private class ModelWatcher
    implements PropertyChangeListener {
        private ModelWatcher() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AutoCompleteSupport.this.throwIllegalStateException("The ComboBoxModel cannot be changed. It was changed to: " + evt.getNewValue());
        }
    }

    private class MoveAction
    extends AbstractAction {
        private final int offset;

        public MoveAction(int offset) {
            this.offset = offset;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AutoCompleteSupport.this.comboBox.isShowing()) {
                if (AutoCompleteSupport.this.comboBox.isPopupVisible()) {
                    AutoCompleteSupport.this.selectPossibleValue(AutoCompleteSupport.this.comboBox.getSelectedIndex() + this.offset);
                } else {
                    AutoCompleteSupport.this.applyFilter(AutoCompleteSupport.this.prefix);
                    AutoCompleteSupport.this.comboBox.showPopup();
                }
            }
        }
    }

    private class PopupMouseHandler
    extends MouseAdapter {
        private PopupMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            AutoCompleteSupport.this.doNotAutoComplete = true;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            AutoCompleteSupport.this.doNotAutoComplete = false;
        }
    }

    private class PopupSizer
    implements PopupMenuListener {
        private PopupSizer() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            Object prototypeValue = AutoCompleteSupport.this.comboBox.getPrototypeDisplayValue();
            if (prototypeValue == null) {
                return;
            }
            JComponent popupComponent = (JComponent)e.getSource();
            if (popupComponent.getComponent(0) instanceof JScrollPane) {
                JScrollPane scroller = (JScrollPane)popupComponent.getComponent(0);
                Dimension scrollerSize = scroller.getPreferredSize();
                Dimension prototypeSize = this.getPrototypeSize(prototypeValue);
                prototypeSize.width += scroller.getVerticalScrollBar().getPreferredSize().width;
                if (prototypeSize.width > scrollerSize.width) {
                    scrollerSize.width = prototypeSize.width;
                    scroller.setMaximumSize(scrollerSize);
                    scroller.setPreferredSize(scrollerSize);
                    scroller.setMinimumSize(scrollerSize);
                }
            }
        }

        private Dimension getPrototypeSize(E prototypeValue) {
            DefaultListCellRenderer renderer = AutoCompleteSupport.this.comboBox.getRenderer();
            if (renderer == null) {
                renderer = new DefaultListCellRenderer();
            }
            Component comp = renderer.getListCellRendererComponent(AutoCompleteSupport.this.popup.getList(), prototypeValue, -1, false, false);
            comp.setFont(AutoCompleteSupport.this.comboBox.getFont());
            return comp.getPreferredSize();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (AutoCompleteSupport.this.doNotClearFilterOnPopupHide) {
                return;
            }
            AutoCompleteSupport.this.applyFilter("");
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    private class StringFunctionRenderer
    extends DefaultListCellRenderer {
        private StringFunctionRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String string = AutoCompleteSupport.this.convertToString(value);
            if (string.length() == 0) {
                string = " ";
            }
            return super.getListCellRendererComponent(list, string, index, isSelected, cellHasFocus);
        }
    }

    private static final class TableCellComboBox<E>
    extends JComboBox<E>
    implements FocusListener {
        public TableCellComboBox() {
            this.setEditor(new TableCellComboBoxEditor());
            TableCellComboBox.replaceUIDelegateFocusListener(this.getEditor().getEditorComponent(), this);
            TableCellComboBox.replaceUIDelegateFocusListener(this, this);
        }

        private static void replaceUIDelegateFocusListener(Component c, FocusListener replacement) {
            FocusListener[] focusListeners = c.getFocusListeners();
            for (int i = 0; i < focusListeners.length; ++i) {
                if (focusListeners[i].getClass().getName().indexOf("ComboBoxUI") == -1) continue;
                c.removeFocusListener(focusListeners[i]);
            }
            c.addFocusListener(replacement);
        }

        @Override
        public void focusGained(FocusEvent e) {
            ComboBoxEditor currentEditor = this.getEditor();
            if (currentEditor != null && currentEditor.getEditorComponent() != e.getSource()) {
                this.repaint();
                if (this.isEditable()) {
                    currentEditor.getEditorComponent().requestFocus();
                }
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            Object currentItem;
            ComboBoxEditor currentEditor = this.getEditor();
            if (!e.isTemporary() && currentEditor != null && currentEditor.getEditorComponent() == e.getSource() && (currentItem = currentEditor.getItem()) != null && !currentItem.equals(this.getSelectedItem())) {
                this.fireActionPerformed(currentEditor);
            }
            this.repaint();
        }

        private void fireActionPerformed(ComboBoxEditor source) {
            this.actionPerformed(new ActionEvent(source, 0, "", EventQueue.getMostRecentEventTime(), 0));
        }

        @Override
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            TableCellTextField tableCellTextField = (TableCellTextField)this.getEditor().getEditorComponent();
            tableCellTextField.processKeyBinding(ks, e, condition, pressed);
            if (!tableCellTextField.hasFocus()) {
                tableCellTextField.requestFocus();
            }
            return super.processKeyBinding(ks, e, condition, pressed);
        }

        @Override
        public void setNextFocusableComponent(Component aComponent) {
            super.setNextFocusableComponent(aComponent);
            ((JComponent)this.getEditor().getEditorComponent()).setNextFocusableComponent(aComponent);
        }

        private static final class TableCellComboBoxEditor
        extends BasicComboBoxEditor {
            public TableCellComboBoxEditor() {
                this.editor = new TableCellTextField();
            }
        }

        private static class TableCellTextField
        extends JTextField {
            public TableCellTextField() {
                super("", 9);
            }

            @Override
            public void setText(String newText) {
                if (!this.equalsText(newText)) {
                    super.setText(newText);
                }
            }

            private boolean equalsText(String newText) {
                String currentText = this.getText();
                return currentText == null ? newText == null : currentText.equals(newText);
            }

            @Override
            public void setBorder(Border b) {
            }

            @Override
            public boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                return super.processKeyBinding(ks, e, condition, pressed);
            }
        }
    }

    private static final class TableColumnValueFunction<E>
    implements FunctionList.Function<E, Object> {
        private final TableFormat<E> tableFormat;
        private final int columnIndex;

        public TableColumnValueFunction(TableFormat<E> tableFormat, int columnIndex) {
            this.tableFormat = tableFormat;
            this.columnIndex = columnIndex;
        }

        @Override
        public Object evaluate(E sourceValue) {
            return this.tableFormat.getColumnValue(sourceValue, this.columnIndex);
        }
    }

    private class UIWatcher
    implements PropertyChangeListener {
        private UIWatcher() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AutoCompleteSupport.this.undecorateOriginalUI();
            AutoCompleteSupport.this.decorateCurrentUI();
        }
    }
}

