/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.numeric.statistics;

import org.apache.commons.math3.stat.StatUtils;

public class ResidualStandardDeviationCalculator {
    public double calculate(double[][] data) {
        double result = 0.0;
        int size = data.length;
        double denominator = (double)size - 2.0;
        if (denominator != 0.0) {
            double sampleFactor = 1.0 / denominator;
            double[] yValues = new double[size];
            double[] xValues = new double[size];
            int i = 0;
            double[][] dArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                double[] pair = dArray[n2];
                double y = pair[0];
                double x = pair[1];
                yValues[i] = y;
                xValues[i] = x;
                ++i;
                ++n2;
            }
            double yMean = StatUtils.mean((double[])yValues);
            double xMean = StatUtils.mean((double[])xValues);
            double sumYMeanSquare = 0.0;
            double sumXMeanSquare = 0.0;
            double sumXMeanYMean = 0.0;
            double[][] dArray2 = data;
            int n3 = data.length;
            int n4 = 0;
            while (n4 < n3) {
                double[] pair = dArray2[n4];
                double y = pair[0];
                double x = pair[1];
                double ym = y - yMean;
                double xm = x - xMean;
                sumYMeanSquare += Math.pow(ym, 2.0);
                sumXMeanSquare += Math.pow(xm, 2.0);
                sumXMeanYMean += xm * ym;
                ++n4;
            }
            double sumXMeanYMeanSquare = Math.pow(sumXMeanYMean, 2.0);
            if (sumXMeanSquare != 0.0) {
                result = Math.sqrt(sampleFactor * (sumYMeanSquare - sumXMeanYMeanSquare / sumXMeanSquare));
            }
        }
        return result;
    }
}

