/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.numeric.internal.gaussjordan;

import org.eclipse.chemclipse.numeric.exceptions.GaussJordanError;

public class GaussJordan {
    public double[][] AtA(double[][] a) {
        int m = a.length;
        int n = a[0].length;
        double[][] ata = new double[n][n];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                int k = 0;
                while (k < n) {
                    double[] dArray = ata[i];
                    int n2 = k;
                    dArray[n2] = dArray[n2] + a[j][i] * a[j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return ata;
    }

    public double[][] AtB(double[][] a, double[][] b) {
        int m = a[0].length;
        int n = a.length;
        double[][] atb = new double[m][m];
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                double[] dArray = atb[i];
                dArray[0] = dArray[0] + a[j][i] * b[j][0];
                ++j;
            }
            ++i;
        }
        return atb;
    }

    public double[] solve(double[][] a, double[][] b) throws GaussJordanError {
        int l;
        int k;
        int icol = 0;
        int irow = 0;
        int n = a.length;
        int m = b.length;
        int[] ipiv = new int[n];
        int[] indxr = new int[n];
        int[] indxc = new int[n];
        int i = 0;
        while (i < n) {
            double big = 0.0;
            int j = 0;
            while (j < n) {
                if (ipiv[j] != 1) {
                    k = 0;
                    while (k < n) {
                        if (ipiv[k] == 0 && Math.abs(a[j][k]) >= big) {
                            big = Math.abs(a[j][k]);
                            irow = j;
                            icol = k;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            int n2 = icol;
            ipiv[n2] = ipiv[n2] + 1;
            if (irow != icol) {
                l = 0;
                while (l < n) {
                    this.swap(a, irow, icol, l);
                    ++l;
                }
                l = 0;
                while (l < m) {
                    this.swap(b, irow, icol, l);
                    ++l;
                }
            }
            indxr[i] = irow;
            indxc[i] = icol;
            if (a[icol][icol] == 0.0) {
                throw new GaussJordanError("gaussj: Singular Matrix");
            }
            double pivinv = 1.0 / a[icol][icol];
            a[icol][icol] = 1.0;
            l = 0;
            while (l < n) {
                double[] dArray = a[icol];
                int n3 = l++;
                dArray[n3] = dArray[n3] * pivinv;
            }
            l = 0;
            while (l < m) {
                double[] dArray = b[icol];
                int n4 = l++;
                dArray[n4] = dArray[n4] * pivinv;
            }
            int ll = 0;
            while (ll < n) {
                if (ll != icol) {
                    double dum = a[ll][icol];
                    a[ll][icol] = 0.0;
                    l = 0;
                    while (l < n) {
                        double[] dArray = a[ll];
                        int n5 = l;
                        dArray[n5] = dArray[n5] - a[icol][l] * dum;
                        ++l;
                    }
                    l = 0;
                    while (l < m) {
                        double[] dArray = b[ll];
                        int n6 = l;
                        dArray[n6] = dArray[n6] - b[icol][l] * dum;
                        ++l;
                    }
                }
                ++ll;
            }
            ++i;
        }
        l = n - 1;
        while (l >= 0) {
            if (indxr[l] != indxc[l]) {
                k = 0;
                while (k < n) {
                    this.swapX(a, k, indxr[l], indxc[l]);
                    ++k;
                }
            }
            --l;
        }
        double[] result = new double[m];
        i = 0;
        while (i < m) {
            result[i] = b[i][0];
            ++i;
        }
        return result;
    }

    private void swap(double[][] array, int irow, int icol, int l) {
        double tmp = array[irow][l];
        array[irow][l] = array[icol][l];
        array[icol][l] = tmp;
    }

    private void swapX(double[][] array, int k, int indxr, int indxc) {
        double tmp = array[k][indxr];
        array[k][indxr] = array[k][indxc];
        array[k][indxc] = tmp;
    }
}

