/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.numeric.core;

import java.util.Comparator;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.miscellaneous.SortOrder;

public class PointYComparator
implements Comparator<IPoint> {
    private SortOrder sortOrder = SortOrder.ASCENDING;

    public PointYComparator() {
        this.sortOrder = SortOrder.ASCENDING;
    }

    public PointYComparator(SortOrder sortOrder) {
        if (sortOrder != null) {
            this.sortOrder = sortOrder;
        }
    }

    @Override
    public int compare(IPoint point1, IPoint point2) {
        int result;
        if (point1 == null || point2 == null) {
            return 0;
        }
        switch (this.sortOrder) {
            case ASCENDING: {
                result = Double.compare(point1.getY(), point2.getY());
                break;
            }
            case DESCENDING: {
                result = Double.compare(point2.getY(), point1.getY());
                break;
            }
            default: {
                result = Double.compare(point1.getY(), point2.getY());
            }
        }
        return result;
    }
}

