/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.chemclipse.support.util.IStringSerialization;

public class FileSettingUtil
implements IStringSerialization<File> {
    private ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public String serialize(List<File> data) {
        String[] savaData = (String[])data.stream().map(File::getAbsolutePath).toArray(String[]::new);
        try {
            return this.objectMapper.writeValueAsString((Object)savaData);
        }
        catch (JsonProcessingException jsonProcessingException) {
            return "";
        }
    }

    @Override
    public List<File> deserialize(String data) {
        if (data != null && !data.isEmpty()) {
            try {
                return Arrays.stream((String[])this.objectMapper.readValue(data, String[].class)).map(s -> new File((String)s)).collect(Collectors.toList());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new ArrayList<File>();
    }
}

