/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.settings.parser;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.chemclipse.support.settings.ComboSettingsProperty;
import org.eclipse.chemclipse.support.settings.DoubleSettingsProperty;
import org.eclipse.chemclipse.support.settings.FileSettingProperty;
import org.eclipse.chemclipse.support.settings.FloatSettingsProperty;
import org.eclipse.chemclipse.support.settings.IntSettingsProperty;
import org.eclipse.chemclipse.support.settings.StringSettingsProperty;
import org.eclipse.chemclipse.support.settings.SystemSettings;
import org.eclipse.chemclipse.support.settings.SystemSettingsStrategy;
import org.eclipse.chemclipse.support.settings.parser.InputValue;
import org.eclipse.chemclipse.support.settings.parser.SettingsParser;
import org.eclipse.chemclipse.support.settings.validation.EvenOddValidator;
import org.eclipse.chemclipse.support.settings.validation.MinMaxValidator;
import org.eclipse.chemclipse.support.settings.validation.RegularExpressionValidator;

public class SettingsClassParser<SettingType>
implements SettingsParser<SettingType> {
    private final Class<SettingType> settingclass;
    private List<InputValue> inputValues;
    private final Object defaultConstructorArgument;

    public SettingsClassParser(Class<SettingType> settingclass, Object defaultConstructorArgument) {
        this.settingclass = settingclass;
        this.defaultConstructorArgument = defaultConstructorArgument;
    }

    public Class<SettingType> getSettingClass() {
        return this.settingclass;
    }

    @Override
    public List<InputValue> getInputValues() {
        if (this.inputValues == null) {
            this.inputValues = new ArrayList<InputValue>();
            Class<SettingType> clazz = this.getSettingClass();
            Object defaultInstance = null;
            if (clazz != null) {
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                JavaType javaType = objectMapper.getSerializationConfig().constructType(clazz);
                BeanDescription beanDescription = objectMapper.getSerializationConfig().introspect(javaType);
                List properties = beanDescription.findProperties();
                for (BeanPropertyDefinition property : properties) {
                    AnnotatedField annotatedField = property.getField();
                    if (annotatedField == null) continue;
                    InputValue inputValue = new InputValue();
                    inputValue.setRawType(annotatedField.getRawType());
                    inputValue.setName(property.getName() == null ? "" : property.getName());
                    PropertyMetadata propertyMetadata = property.getMetadata();
                    inputValue.setDescription(propertyMetadata.getDescription() == null ? "" : propertyMetadata.getDescription());
                    Object defaultValue = propertyMetadata.getDefaultValue();
                    if (defaultValue == null) {
                        AnnotatedMethod getter;
                        if (defaultInstance == null) {
                            defaultInstance = this.createDefaultInstance();
                        }
                        if (defaultInstance != null && (getter = property.getGetter()) != null) {
                            defaultValue = getter.getValue(defaultInstance);
                        }
                    }
                    inputValue.setDefaultValue(defaultValue == null ? "" : defaultValue);
                    this.inputValues.add(inputValue);
                    Iterable annotations = annotatedField.getAllAnnotations().annotations();
                    for (Annotation annotation : annotations) {
                        Annotation settingsProperty;
                        if (annotation instanceof IntSettingsProperty) {
                            settingsProperty = (IntSettingsProperty)annotation;
                            inputValue.addValidator(new MinMaxValidator<Integer>(property.getName(), settingsProperty.minValue(), settingsProperty.maxValue(), Integer.class));
                            inputValue.addValidator(new EvenOddValidator(property.getName(), settingsProperty.validation()));
                            continue;
                        }
                        if (annotation instanceof FloatSettingsProperty) {
                            settingsProperty = (FloatSettingsProperty)annotation;
                            inputValue.addValidator(new MinMaxValidator<Float>(property.getName(), Float.valueOf(settingsProperty.minValue()), Float.valueOf(settingsProperty.maxValue()), Float.class));
                            continue;
                        }
                        if (annotation instanceof DoubleSettingsProperty) {
                            settingsProperty = (DoubleSettingsProperty)annotation;
                            inputValue.addValidator(new MinMaxValidator<Double>(property.getName(), settingsProperty.minValue(), settingsProperty.maxValue(), Double.class));
                            continue;
                        }
                        if (annotation instanceof StringSettingsProperty) {
                            settingsProperty = (StringSettingsProperty)annotation;
                            String regExp = settingsProperty.regExp();
                            if (regExp != null && !regExp.isEmpty()) {
                                inputValue.addValidator(new RegularExpressionValidator(property.getName(), Pattern.compile(regExp), settingsProperty.isMultiLine()));
                            }
                            inputValue.setMultiLine(settingsProperty.isMultiLine());
                            continue;
                        }
                        if (annotation instanceof FileSettingProperty) {
                            inputValue.setFileSettingProperty((FileSettingProperty)annotation);
                            continue;
                        }
                        if (!(annotation instanceof ComboSettingsProperty)) continue;
                        try {
                            inputValue.setComboSupplier(((ComboSettingsProperty)annotation).value().newInstance());
                        }
                        catch (IllegalAccessException | InstantiationException e) {
                            throw new RuntimeException("can't create specified ComboSupplier", e);
                        }
                    }
                }
            }
        }
        return this.inputValues;
    }

    @Override
    public SystemSettingsStrategy getSystemSettingsStrategy() {
        Class<SettingType> clazz = this.getSettingClass();
        if (clazz == null) {
            return SystemSettingsStrategy.NULL;
        }
        SystemSettings annotation = clazz.getAnnotation(SystemSettings.class);
        if (annotation != null) {
            String checkMethod = annotation.dynamicCheckMethod();
            if (annotation.value() == SystemSettingsStrategy.DYNAMIC && !checkMethod.isEmpty()) {
                try {
                    Method method = clazz.getMethod(checkMethod, new Class[0]);
                    Object result = method.invoke(null, new Object[0]);
                    if (result instanceof SystemSettingsStrategy) {
                        return (SystemSettingsStrategy)((Object)result);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new RuntimeException("specified dynamic check method can't be used", e);
                }
            }
            return annotation.value();
        }
        return SystemSettingsStrategy.NULL;
    }

    @Override
    public SettingType createDefaultInstance() {
        Class<SettingType> settingsClass = this.getSettingClass();
        if (settingsClass != null) {
            try {
                if (this.defaultConstructorArgument != null) {
                    Constructor<?>[] constructors;
                    Constructor<?>[] constructorArray = constructors = settingsClass.getConstructors();
                    int n = constructors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Class<?> parameter;
                        Constructor<?> constructor = constructorArray[n2];
                        if (constructor.getParameterCount() == 1 && (parameter = constructor.getParameterTypes()[0]).isInstance(this.defaultConstructorArgument)) {
                            return settingsClass.cast(constructor.newInstance(this.defaultConstructorArgument));
                        }
                        ++n2;
                    }
                }
                return settingsClass.newInstance();
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException("can't create settings instance: " + e.getMessage(), e);
            }
        }
        return null;
    }
}

