/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.chemclipse.logging.support.Settings;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={})
public class ConfigReader {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigReader.class);
    private static final String CFG_EXTENSION = ".cfg";
    private ConfigurationAdmin configurationAdmin;
    private static final FileFilter CFG_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.isFile() && file.getName().endsWith(ConfigReader.CFG_EXTENSION);
        }
    };

    @Activate
    public void start() {
        File directory = Settings.getSystemConfigDirectory();
        if (directory.isDirectory()) {
            LOG.info("Reading static config files from " + directory.getAbsolutePath());
            File[] fileArray = directory.listFiles(CFG_FILE_FILTER);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    this.readConfigFile(file, null);
                } else if (file.isDirectory()) {
                    String fpid = file.getName();
                    File[] fileArray2 = file.listFiles(CFG_FILE_FILTER);
                    int n3 = fileArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File factoryFile = fileArray2[n4];
                        this.readConfigFile(factoryFile, fpid);
                        ++n4;
                    }
                }
                ++n2;
            }
        } else {
            LOG.debug("Directory {} does not exits, no static configuration is read", (Object)directory);
        }
    }

    public void readConfigFile(File file, String fpid) {
        String name = file.getName();
        try {
            Configuration configuration;
            if (fpid == null) {
                String pid = name.substring(0, name.length() - CFG_EXTENSION.length());
                configuration = this.configurationAdmin.getConfiguration(pid, null);
            } else {
                Configuration[] configurations = this.configurationAdmin.listConfigurations("(&(.configreader.file=" + file.getName() + ")(service.factoryPid=" + fpid + "))");
                configuration = configurations == null || configurations.length == 0 ? this.configurationAdmin.createFactoryConfiguration(fpid, null) : configurations[0];
            }
            Dictionary oldProperties = configuration.getProperties();
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put(".configreader.file", file.getName());
            Properties cfg = new Properties();
            Throwable throwable = null;
            Object var9_12 = null;
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                cfg.load(fileInputStream);
                boolean changed = oldProperties == null ? true : oldProperties.size() != cfg.size();
                for (String key : cfg.stringPropertyNames()) {
                    Object oldValue;
                    String property = cfg.getProperty(key);
                    properties.put(key, property);
                    if (oldProperties == null || property.equals(oldValue = oldProperties.get(key))) continue;
                    changed = true;
                }
                if (changed) {
                    configuration.update(properties);
                    LOG.info("Updated configuration " + configuration.getPid() + " from file " + name);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOG.error("Reading configfile " + file.getAbsolutePath() + " failed!", (Throwable)e);
        }
        catch (InvalidSyntaxException e) {
            LOG.error("Reading configfile " + file.getAbsolutePath() + " failed!", (Throwable)e);
        }
    }

    @Reference(unbind="-")
    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }
}

