/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.keystore.core;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.chemclipse.keystore.core.IKeyStore;
import org.eclipse.chemclipse.keystore.exceptions.NoKeyAvailableException;
import org.eclipse.chemclipse.keystore.internal.support.KeyFileParser;
import org.eclipse.core.runtime.Platform;

public class KeyStore
implements IKeyStore {
    private static final String KEYSTORE_FILE_NAME = "keystore";
    private Map<String, String> keyMap;

    public KeyStore() {
        this.initializeKeyMap();
    }

    @Override
    public TreeSet<String> getRegisteredIds() {
        return new TreeSet<String>(this.keyMap.keySet());
    }

    @Override
    public String getSerial(String id) throws NoKeyAvailableException {
        String serial = this.keyMap.get(id);
        if (serial == null || serial.equals("")) {
            throw new NoKeyAvailableException("The serial for the id " + id + " is not available.");
        }
        return serial;
    }

    @Override
    public boolean containsSerial(String id) {
        return this.keyMap.containsKey(id);
    }

    @Override
    public void reload() {
        this.initializeKeyMap();
    }

    private void initializeKeyMap() {
        String path = Platform.getInstallLocation().getURL().getPath();
        File file = new File(String.valueOf(path) + File.separator + KEYSTORE_FILE_NAME);
        this.keyMap = file.exists() ? KeyFileParser.readKeysFromFile(file) : new HashMap<String, String>();
    }
}

