/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.nebula.visualization.xygraph.util.GraphicsUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public final class XYGraphMediaFactory {
    private static XYGraphMediaFactory _instance;
    private ColorRegistry _colorRegistry = new ColorRegistry();
    private ImageRegistry _imageRegistry = new ImageRegistry();
    private FontRegistry _fontRegistry = new FontRegistry();
    private HashMap<String, Cursor> cursorRegistry = new HashMap();
    private HashMap<ImageDescriptor, Image> _imageCache = new HashMap();
    public static final String CURSOR_GRABBING_PATH = "images/Grabbing.png";
    public static final String CURSOR_GRABBING_ON_AXIS_PATH = "images/GrabbingOnAxis.png";
    public static final RGB COLOR_LIGHT_BLUE;
    public static final RGB COLOR_BLUE;
    public static final RGB COLOR_WHITE;
    public static final RGB COLOR_GRAY;
    public static final RGB COLOR_DARK_GRAY;
    public static final RGB COLOR_BLACK;
    public static final RGB COLOR_RED;
    public static final RGB COLOR_GREEN;
    public static final RGB COLOR_YELLOW;
    public static final RGB COLOR_PINK;
    public static final RGB COLOR_CYAN;
    public static final RGB COLOR_ORANGE;
    public static final RGB COLOR_PURPLE;
    public static final FontData FONT_ARIAL;
    public static final FontData FONT_TAHOMA;

    static {
        COLOR_LIGHT_BLUE = new RGB(153, 186, 243);
        COLOR_BLUE = new RGB(0, 0, 255);
        COLOR_WHITE = new RGB(255, 255, 255);
        COLOR_GRAY = new RGB(200, 200, 200);
        COLOR_DARK_GRAY = new RGB(150, 150, 150);
        COLOR_BLACK = new RGB(0, 0, 0);
        COLOR_RED = new RGB(255, 0, 0);
        COLOR_GREEN = new RGB(0, 255, 0);
        COLOR_YELLOW = new RGB(255, 255, 0);
        COLOR_PINK = new RGB(255, 0, 255);
        COLOR_CYAN = new RGB(0, 255, 255);
        COLOR_ORANGE = new RGB(255, 128, 0);
        COLOR_PURPLE = new RGB(128, 0, 255);
        FONT_ARIAL = new FontData("Arial", 9, 0);
        FONT_TAHOMA = new FontData("Tahoma", 9, 0);
    }

    public void disposeResources() {
        if (this.cursorRegistry != null) {
            for (Cursor cursor : this.cursorRegistry.values()) {
                if (cursor == null || cursor.isDisposed()) continue;
                cursor.dispose();
            }
            this.cursorRegistry.clear();
        }
    }

    public Cursor getCursor(String cursorImagePath) {
        Cursor cursor = this.cursorRegistry.get(cursorImagePath);
        if (cursor == null) {
            cursor = GraphicsUtil.createCursor((Device)Display.getDefault(), XYGraphMediaFactory.getInstance().getImage(cursorImagePath).getImageData(), 8, 8);
            this.cursorRegistry.put(cursorImagePath, cursor);
        }
        return cursor;
    }

    private XYGraphMediaFactory() {
        Display.getDefault().addListener(12, new Listener(){

            public void handleEvent(Event event) {
                for (Image img : XYGraphMediaFactory.this._imageCache.values()) {
                    img.dispose();
                }
                XYGraphMediaFactory.this.disposeResources();
            }
        });
    }

    public static synchronized XYGraphMediaFactory getInstance() {
        if (_instance == null) {
            _instance = new XYGraphMediaFactory();
        }
        return _instance;
    }

    public Color getColor(int r, int g, int b) {
        return this.getColor(new RGB(r, g, b));
    }

    public Color getColor(RGB rgb) {
        assert (rgb != null) : "rgb!=null";
        Color result = null;
        String key = String.valueOf(rgb.hashCode());
        if (!this._colorRegistry.hasValueFor(key)) {
            this._colorRegistry.put(key, rgb);
        }
        result = this._colorRegistry.get(key);
        return result;
    }

    public Font getFont(String name, int height, int style) {
        assert (name != null) : "name!=null";
        FontData fd = new FontData(name, height, style);
        String key = String.valueOf(fd.hashCode());
        if (!this._fontRegistry.hasValueFor(key)) {
            this._fontRegistry.put(key, new FontData[]{fd});
        }
        return this._fontRegistry.get(key);
    }

    public Font getFont(FontData[] fontData) {
        FontData f = fontData[0];
        return this.getFont(f.getName(), f.getHeight(), f.getStyle());
    }

    public Font getFont(FontData[] fontData, int style) {
        FontData f = fontData[0];
        Font font = this.getFont(f.getName(), f.getHeight(), style);
        return font;
    }

    public Font getFont(FontData fontData) {
        Font font = this.getFont(fontData.getName(), fontData.getHeight(), fontData.getStyle());
        return font;
    }

    public Font getDefaultFont(int style) {
        return Display.getDefault().getSystemFont();
    }

    public void registerImage(String key, Image img) {
        this._imageRegistry.put(key, img);
    }

    public Image getRegisteredImage(String key) {
        return this._imageRegistry.get(key);
    }

    public Image getImage(String relativePath) {
        if (this._imageRegistry.get(relativePath) == null) {
            InputStream stream = XYGraphMediaFactory.class.getResourceAsStream(relativePath);
            Image image = new Image((Device)Display.getCurrent(), stream);
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._imageRegistry.put(relativePath, image);
        }
        return this._imageRegistry.get(relativePath);
    }

    public void registerCursor(String key, Cursor cursor) {
        this.cursorRegistry.put(key, cursor);
    }
}

