/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.figures;

import org.eclipse.nebula.visualization.xygraph.Messages;
import org.eclipse.nebula.visualization.xygraph.util.SingleSourceHelper2;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public enum ZoomType {
    RUBBERBAND_ZOOM(Messages.Zoom_Rubberband, XYGraphMediaFactory.getInstance().getImage("images/RubberbandZoom.png"), XYGraphMediaFactory.getInstance().getImage("images/RubberbandZoomCursor.png"), XYGraphMediaFactory.getInstance().getImage("images/HorizontalZoomCursorOnXAxis.png"), XYGraphMediaFactory.getInstance().getImage("images/VerticalZoomCursorOnYAxis.png"), 3, 2),
    DYNAMIC_ZOOM(Messages.Zoom_Dynamic, XYGraphMediaFactory.getInstance().getImage("images/RubberbandZoom.png"), XYGraphMediaFactory.getInstance().getImage("images/RubberbandZoomCursor.png"), XYGraphMediaFactory.getInstance().getImage("images/HorizontalZoomCursorOnXAxis.png"), XYGraphMediaFactory.getInstance().getImage("images/VerticalZoomCursorOnYAxis.png"), 3, 2),
    HORIZONTAL_ZOOM(Messages.Zoom_Horiz, XYGraphMediaFactory.getInstance().getImage("images/HorizontalZoom.png"), XYGraphMediaFactory.getInstance().getImage("images/HorizontalZoomCursor.png"), XYGraphMediaFactory.getInstance().getImage("images/HorizontalZoomCursorOnXAxis.png"), null, 3, 9),
    VERTICAL_ZOOM(Messages.Zoom_Vert, XYGraphMediaFactory.getInstance().getImage("images/VerticalZoom.png"), XYGraphMediaFactory.getInstance().getImage("images/VerticalZoomCursor.png"), null, XYGraphMediaFactory.getInstance().getImage("images/VerticalZoomCursorOnYAxis.png"), 3, 7),
    ZOOM_IN(Messages.Zoom_In, XYGraphMediaFactory.getInstance().getImage("images/ZoomIn.png"), XYGraphMediaFactory.getInstance().getImage("images/ZoomInCursor.png"), XYGraphMediaFactory.getInstance().getImage("images/ZoomInCursorOnXAxis.png"), XYGraphMediaFactory.getInstance().getImage("images/ZoomInCursorOnYAxis.png"), 1, 21),
    ZOOM_OUT(Messages.Zoom_Out, XYGraphMediaFactory.getInstance().getImage("images/ZoomOut.png"), XYGraphMediaFactory.getInstance().getImage("images/ZoomOutCursor.png"), XYGraphMediaFactory.getInstance().getImage("images/ZoomOutCursorOnXAxis.png"), XYGraphMediaFactory.getInstance().getImage("images/ZoomOutCursorOnYAxis.png"), 1, 21),
    ZOOM_IN_HORIZONTALLY(Messages.Zoom_InHoriz, XYGraphMediaFactory.getInstance().getImage("images/ZoomInHoriz.png"), XYGraphMediaFactory.getInstance().getImage("images/ZoomInHorizCursor.png"), XYGraphMediaFactory.getInstance().getImage("images/ZoomInCursorOnXAxis.png"), null, 2, 9),
    ZOOM_OUT_HORIZONTALLY(Messages.Zoom_OutHoriz, XYGraphMediaFactory.getInstance().getImage("images/ZoomOutHoriz.png"), XYGraphMediaFactory.getInstance().getImage("images/ZoomOutHorizCursor.png"), XYGraphMediaFactory.getInstance().getImage("images/ZoomOutCursorOnXAxis.png"), null, 2, 9),
    ZOOM_IN_VERTICALLY(Messages.Zoom_InVert, XYGraphMediaFactory.getInstance().getImage("images/ZoomInVert.png"), XYGraphMediaFactory.getInstance().getImage("images/ZoomInVertCursor.png"), null, XYGraphMediaFactory.getInstance().getImage("images/ZoomInCursorOnYAxis.png"), 2, 7),
    ZOOM_OUT_VERTICALLY(Messages.Zoom_OutVert, XYGraphMediaFactory.getInstance().getImage("images/ZoomOutVert.png"), XYGraphMediaFactory.getInstance().getImage("images/ZoomOutVertCursor.png"), null, XYGraphMediaFactory.getInstance().getImage("images/ZoomOutCursorOnYAxis.png"), 2, 7),
    PANNING(Messages.Zoom_Pan, XYGraphMediaFactory.getInstance().getImage("images/Panning.png"), XYGraphMediaFactory.getInstance().getImage("images/PanningCursor.png"), XYGraphMediaFactory.getInstance().getImage("images/PanningCursorOnAxis.png"), XYGraphMediaFactory.getInstance().getImage("images/PanningCursorOnAxis.png"), 3, 5, false),
    NONE(Messages.Zoom_None, XYGraphMediaFactory.getInstance().getImage("images/MouseArrow.png"), null, null, null, 3, 0, false);

    private final Image iconImage;
    private final String description;
    private Cursor overrideCursor;
    private final Cursor defaultCursor;
    private final Cursor cursorOnXAxis;
    private final Cursor cursorOnYAxis;
    private final int flags;
    private final boolean isZoom;

    private ZoomType(String description, Image iconImage, Image cursorImage, Image cursorImageOnXAxis, Image cursorImageOnYAxis, int flags, int backUpSWTCursorType) {
        this(description, iconImage, cursorImage, cursorImageOnXAxis, cursorImageOnYAxis, flags, backUpSWTCursorType, true);
    }

    private ZoomType(String description, Image iconImage, Image cursorImage, Image cursorImageOnXAxis, Image cursorImageOnYAxis, int flags, int backUpSWTCursorType, boolean isZoom) {
        this.description = description;
        this.iconImage = iconImage;
        this.defaultCursor = cursorImage == null ? Display.getDefault().getSystemCursor(0) : SingleSourceHelper2.createCursor(Display.getDefault(), cursorImage.getImageData(), 8, 8, backUpSWTCursorType);
        this.cursorOnXAxis = cursorImageOnXAxis == null ? this.defaultCursor : SingleSourceHelper2.createCursor(Display.getDefault(), cursorImageOnXAxis.getImageData(), 8, 8, backUpSWTCursorType);
        this.cursorOnYAxis = cursorImageOnYAxis == null ? this.defaultCursor : SingleSourceHelper2.createCursor(Display.getDefault(), cursorImageOnYAxis.getImageData(), 8, 8, backUpSWTCursorType);
        this.flags = flags;
        this.isZoom = isZoom;
    }

    public Image getIconImage() {
        return this.iconImage;
    }

    public String getDescription() {
        return this.description;
    }

    public Cursor getCursor() {
        if (this.overrideCursor != null) {
            return this.overrideCursor;
        }
        return this.defaultCursor;
    }

    public Cursor getCursorOnAxis(boolean horizontalAxis) {
        if (this.overrideCursor != null) {
            return this.overrideCursor;
        }
        if (horizontalAxis) {
            return this.cursorOnXAxis;
        }
        return this.cursorOnYAxis;
    }

    public boolean useWithFlags(int flags) {
        return (this.flags & flags) > 0;
    }

    public String toString() {
        return this.description;
    }

    public String getId() {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + "." + this.name();
    }

    @Deprecated
    public void setCursor(Cursor cursor) {
        this.overrideCursor = cursor;
    }

    public boolean isZoom() {
        return this.isZoom;
    }
}

