/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.methods;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.chemclipse.converter.methods.MetaProcessorProcessSupplier;
import org.eclipse.chemclipse.model.methods.ListProcessEntryContainer;
import org.eclipse.chemclipse.processing.methods.IProcessEntry;
import org.eclipse.chemclipse.processing.methods.IProcessMethod;
import org.eclipse.chemclipse.processing.methods.ProcessEntryContainer;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.ProcessorPreferences;
import org.eclipse.chemclipse.support.settings.SystemSettings;
import org.eclipse.chemclipse.support.settings.SystemSettingsStrategy;

@SystemSettings(value=SystemSettingsStrategy.NEW_INSTANCE)
public class MetaProcessorSettings {
    @JsonProperty(value="Settings", defaultValue="")
    private Map<String, String> settingsMap;
    @JsonProperty(value="Defaults", defaultValue="")
    private Map<String, Boolean> useDefaultMap;
    @JsonIgnore
    private final IProcessMethod method;

    public MetaProcessorSettings(MetaProcessorProcessSupplier processSupplier) {
        this.method = processSupplier.getMethod();
    }

    private Map<String, String> getSettingsMap() {
        if (this.settingsMap == null) {
            this.settingsMap = new HashMap<String, String>();
        }
        return this.settingsMap;
    }

    private Map<String, Boolean> getUseDefaultMap() {
        if (this.useDefaultMap == null) {
            this.useDefaultMap = new HashMap<String, Boolean>();
        }
        return this.useDefaultMap;
    }

    @JsonIgnore
    public IProcessMethod getMethod() {
        return this.method;
    }

    public <T> ProcessorPreferences<T> getProcessorPreferences(IProcessEntry entry, final ProcessorPreferences<T> delegate) {
        if (delegate == null) {
            return null;
        }
        final String entryId = MetaProcessorSettings.getId(entry);
        return new ProcessorPreferences<T>(){

            public ProcessorPreferences.DialogBehavior getDialogBehaviour() {
                return ProcessorPreferences.DialogBehavior.NONE;
            }

            public void setAskForSettings(boolean askForSettings) {
            }

            public void setUserSettings(String settings) {
                if (settings == null || settings.isEmpty()) {
                    MetaProcessorSettings.this.getSettingsMap().remove(entryId);
                } else {
                    MetaProcessorSettings.this.getSettingsMap().put(entryId, settings);
                }
            }

            public boolean isUseSystemDefaults() {
                return MetaProcessorSettings.this.getUseDefaultMap().getOrDefault(entryId, delegate.isUseSystemDefaults());
            }

            public void setUseSystemDefaults(boolean useSystemDefaults) {
                MetaProcessorSettings.this.getUseDefaultMap().put(entryId, useSystemDefaults);
            }

            public void reset() {
                MetaProcessorSettings.this.getSettingsMap().remove(entryId);
                MetaProcessorSettings.this.getUseDefaultMap().remove(entryId);
            }

            public IProcessSupplier<T> getSupplier() {
                return delegate.getSupplier();
            }

            public String getUserSettingsAsString() {
                return MetaProcessorSettings.this.getSettingsMap().getOrDefault(entryId, delegate.getUserSettingsAsString());
            }
        };
    }

    public static String getId(IProcessEntry entry) {
        ProcessEntryContainer parent = entry.getParent();
        if (parent instanceof ListProcessEntryContainer) {
            String id = String.valueOf(((ListProcessEntryContainer)parent).getEntries().indexOf(entry));
            if (parent instanceof IProcessEntry) {
                return String.valueOf(MetaProcessorSettings.getId((IProcessEntry)parent)) + "." + id;
            }
            return id;
        }
        throw new IllegalArgumentException("unsupported parent type");
    }
}

