/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.core.IBaselineDetectorSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.core.IBaselineDetectorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.exceptions.NoBaselineDetectorAvailableException;

public class BaselineDetectorSupport
implements IBaselineDetectorSupport {
    private List<IBaselineDetectorSupplier> suppliers = new ArrayList<IBaselineDetectorSupplier>();

    protected void add(IBaselineDetectorSupplier supplier) {
        this.suppliers.add(supplier);
    }

    @Override
    public List<String> getAvailableDetectorIds() throws NoBaselineDetectorAvailableException {
        this.areDetectorsStored();
        ArrayList<String> availableDetectors = new ArrayList<String>();
        for (IBaselineDetectorSupplier supplier : this.suppliers) {
            availableDetectors.add(supplier.getId());
        }
        return availableDetectors;
    }

    @Override
    public IBaselineDetectorSupplier getBaselineDetectorSupplier(String detectorId) throws NoBaselineDetectorAvailableException {
        IBaselineDetectorSupplier detectorSupplier = null;
        this.areDetectorsStored();
        if (detectorId == null || detectorId.equals("")) {
            throw new NoBaselineDetectorAvailableException("There is no baseline detector available with the following id: " + detectorId + ".");
        }
        for (IBaselineDetectorSupplier supplier : this.suppliers) {
            if (!supplier.getId().equals(detectorId)) continue;
            detectorSupplier = supplier;
            break;
        }
        if (detectorSupplier == null) {
            throw new NoBaselineDetectorAvailableException("There is no baseline detector available with the following id: " + detectorId + ".");
        }
        return detectorSupplier;
    }

    @Override
    public String getDetectorId(int index) throws NoBaselineDetectorAvailableException {
        this.areDetectorsStored();
        if (index < 0 || index > this.suppliers.size() - 1) {
            throw new NoBaselineDetectorAvailableException("There is no baseline detector available with the following id: " + index + ".");
        }
        IBaselineDetectorSupplier supplier = this.suppliers.get(index);
        return supplier.getId();
    }

    @Override
    public String[] getDetectorNames() throws NoBaselineDetectorAvailableException {
        this.areDetectorsStored();
        ArrayList<String> detectorNames = new ArrayList<String>();
        for (IBaselineDetectorSupplier supplier : this.suppliers) {
            detectorNames.add(supplier.getDetectorName());
        }
        return detectorNames.toArray(new String[detectorNames.size()]);
    }

    private void areDetectorsStored() throws NoBaselineDetectorAvailableException {
        if (this.suppliers.size() < 1) {
            throw new NoBaselineDetectorAvailableException();
        }
    }
}

