/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.matlab.parafac.converter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.msd.converter.peak.AbstractPeakExportConverter;
import org.eclipse.chemclipse.msd.converter.supplier.matlab.parafac.internal.converter.SpecificationValidator;
import org.eclipse.chemclipse.msd.converter.supplier.matlab.parafac.io.MatlabParafacPeakWriter;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.IProgressMonitor;

public class MatlabParafacPeakExportConverter
extends AbstractPeakExportConverter {
    private static final Logger logger = Logger.getLogger(MatlabParafacPeakExportConverter.class);

    public IProcessingInfo convert(File file, IPeaks peaks, boolean append, IProgressMonitor monitor) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        IProcessingInfo processingInfoValidate = this.validate(file = SpecificationValidator.validateSpecification(file), peaks);
        if (processingInfoValidate.hasErrorMessages()) {
            processingInfo.addMessages(processingInfoValidate);
        } else {
            try {
                MatlabParafacPeakWriter peakWriter = new MatlabParafacPeakWriter();
                IProcessingInfo processingInfoWriter = peakWriter.write(file, peaks, append);
                processingInfo.addMessages(processingInfoWriter);
                processingInfo.setProcessingResult(processingInfoWriter.getProcessingResult());
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)e);
                ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Export Peaks", "The given file was not found: " + file.getAbsolutePath());
                processingInfo.addMessage((IProcessingMessage)processingMessage);
            }
            catch (FileIsNotWriteableException e) {
                logger.warn((Object)e);
                ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Export Peaks", "The given file is not writable: " + file.getAbsolutePath());
                processingInfo.addMessage((IProcessingMessage)processingMessage);
            }
            catch (IOException e) {
                logger.warn((Object)e);
                ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Export Peaks", "There has gone something wrong writing the file: " + file.getAbsolutePath());
                processingInfo.addMessage((IProcessingMessage)processingMessage);
            }
        }
        return processingInfo;
    }

    private IProcessingInfo validate(File file, IPeakMSD peak) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addMessages(super.validate(file));
        processingInfo.addMessages(super.validate(peak));
        return processingInfo;
    }

    private IProcessingInfo validate(File file, IPeaks peaks) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addMessages(super.validate(file));
        processingInfo.addMessages(super.validate(peaks));
        return processingInfo;
    }
}

