/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.wizards;

import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.support.messages.SupportMessages;
import org.eclipse.chemclipse.support.ui.wizards.AbstractWizard;
import org.eclipse.chemclipse.support.ui.wizards.IWizardElements;
import org.eclipse.chemclipse.support.ui.wizards.SelectFileWizardPage;
import org.eclipse.chemclipse.support.ui.wizards.SelectProjectWizardPage;
import org.eclipse.chemclipse.support.ui.wizards.WizardElements;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public abstract class AbstractFileWizard
extends AbstractWizard {
    private static final Logger logger = Logger.getLogger(AbstractFileWizard.class);
    private ISelection selection;
    private String defaultFileName;
    private String fileExtension;

    public AbstractFileWizard(String defaultFileName, String fileExtension) {
        this(new WizardElements(), defaultFileName, fileExtension);
    }

    public AbstractFileWizard(IWizardElements wizardElements, String defaultFileName, String fileExtension) {
        super(wizardElements);
        this.defaultFileName = defaultFileName;
        this.fileExtension = fileExtension;
    }

    public void addPages() {
        this.addPage(new SelectProjectWizardPage(this.selection, this.getWizardElements()));
        this.addPage(new SelectFileWizardPage(this.getWizardElements(), this.defaultFileName, this.fileExtension));
    }

    protected IFile prepareProject(IProgressMonitor monitor) throws CoreException {
        IContainer container = this.getWizardElements().getContainer();
        String fileName = this.getWizardElements().getFileName();
        monitor.subTask(SupportMessages.INSTANCE().getMessage("taskPrepareProject", new String[0]));
        if (container instanceof IProject) {
            IProject project = (IProject)container;
            if (!project.exists()) {
                project.create(monitor);
                project.open(monitor);
            }
            if (!project.isOpen()) {
                project.open(monitor);
            }
        }
        return container.getFile((IPath)new Path(fileName));
    }

    protected void runOpenEditor(final IFile file, IProgressMonitor monitor) {
        monitor.subTask(SupportMessages.INSTANCE().getMessage("taskOpenEditor", new String[0]));
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException e) {
                    logger.warn((Object)e);
                }
            }
        });
    }

    protected void refreshWorkspace(IProgressMonitor monitor) throws CoreException {
        IContainer container = this.getWizardElements().getContainer();
        if (container != null) {
            container.refreshLocal(1, monitor);
        }
    }
}

