/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.swt.edit;

import org.eclipse.chemclipse.support.ui.swt.ControlBuilder;
import org.eclipse.chemclipse.support.ui.swt.edit.EditValue;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TextEdit
extends EditValue<String> {
    private final Text text;
    private final String initialText;
    private String editedValue = "";

    public TextEdit(Composite parent, String initialText) {
        if (initialText == null) {
            initialText = "";
        }
        this.initialText = initialText;
        this.editedValue = initialText;
        this.text = ControlBuilder.fill(new Text(parent, 0));
        this.text.setText(initialText);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextEdit.this.editedValue = TextEdit.this.text.getText();
                TextEdit.this.setChanged();
                TextEdit.this.notifyObservers(TextEdit.this.editedValue);
            }
        });
    }

    @Override
    public boolean isEdited() {
        return !this.editedValue.equals(this.initialText);
    }

    @Override
    public String getValue() {
        return this.editedValue;
    }

    @Override
    public Control getControl() {
        return this.text;
    }
}

