/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.swt;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.chemclipse.support.settings.OperatingSystemUtils;
import org.eclipse.chemclipse.support.ui.swt.columns.ColumnDefinition;
import org.eclipse.chemclipse.support.ui.swt.columns.ColumnDefinitionProvider;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ControlBuilder {
    private static final boolean WINDOWS = OperatingSystemUtils.isWindows();

    public static Composite createContainer(Composite parent) {
        return ControlBuilder.createContainer(parent, 1);
    }

    public static Composite createContainer(Composite parent, int columns) {
        return ControlBuilder.createContainer(parent, columns, false);
    }

    public static Composite createDefault(Composite parent, int columns) {
        Composite composite = new Composite(parent, 0);
        composite.setBackgroundMode(2);
        GridLayout layout = new GridLayout(columns, false);
        composite.setLayout((Layout)layout);
        return ControlBuilder.fill(composite);
    }

    public static Group createGroup(Composite parent, int columns, String text) {
        Group group = new Group(parent, 16);
        group.setText(text);
        group.setLayout((Layout)new GridLayout(columns, false));
        return group;
    }

    public static Button checkbox(Composite composite, String text, boolean initialSelection) {
        Button button = new Button(composite, 32);
        button.setText(text);
        button.setSelection(initialSelection);
        return button;
    }

    public static Button radiobutton(Composite composite, String text, boolean initialSelection) {
        Button button = new Button(composite, 16);
        button.setText(text);
        button.setSelection(initialSelection);
        return button;
    }

    public static Text textfield(Composite composite, String initialText) {
        Text text = new Text(composite, WINDOWS ? 2048 : 0);
        if (initialText != null) {
            text.setText(initialText);
        }
        return ControlBuilder.fill(text);
    }

    public static Text onEditUpdate(final Text text, final Consumer<String> consumer) {
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent me) {
                if (!text.isDisposed()) {
                    consumer.accept(text.getText());
                }
            }
        });
        return text;
    }

    public static Composite indentedContainer(Composite parent, int indentation) {
        Composite container = ControlBuilder.createContainer(parent);
        ControlBuilder.gridData((Control)container).horizontalIndent = indentation;
        return container;
    }

    public static Composite createContainer(Composite parent, int columns, boolean equal) {
        Composite composite = new Composite(parent, 0);
        composite.setBackgroundMode(2);
        GridLayout layout = new GridLayout(columns, equal);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginTop = 0;
        layout.marginRight = 0;
        composite.setLayout((Layout)layout);
        return ControlBuilder.fill(composite);
    }

    public static <T extends Composite> T spacing(T control, int margins) {
        Layout layout = control.getLayout();
        if (layout instanceof GridLayout) {
            GridLayout gridLayout = (GridLayout)layout;
            gridLayout.marginBottom = margins;
            gridLayout.marginLeft = margins;
            gridLayout.marginTop = margins;
            gridLayout.marginRight = margins;
        }
        return control;
    }

    public static Label label(String label, Composite container) {
        return ControlBuilder.label(label, null, container);
    }

    public static Label separator(Composite container) {
        return ControlBuilder.fill(new Label(container, 258));
    }

    public static Label label(String label, String tooltip, Composite container) {
        Label labelComponent = new Label(container, 0);
        labelComponent.setText(label);
        if (tooltip != null) {
            labelComponent.setToolTipText(tooltip);
        }
        return labelComponent;
    }

    public static <T extends Control> T top(T control) {
        ControlBuilder.gridData(control).verticalAlignment = 128;
        return control;
    }

    public static <T extends Control> T bottom(T control) {
        ControlBuilder.gridData(control).verticalAlignment = 1024;
        return control;
    }

    public static <T extends Control> T center(T control) {
        ControlBuilder.gridData(control).verticalAlignment = 0x1000000;
        return control;
    }

    public static <T extends Control> T fill(T control) {
        if (ControlBuilder.isGridLayouted(control)) {
            GridData data = ControlBuilder.gridData(control);
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
        }
        return control;
    }

    public static <T extends Control> T maximize(T control) {
        GridData gridData = ControlBuilder.gridData(control);
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        return control;
    }

    public static Composite createLabelContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        return ControlBuilder.fill(composite);
    }

    public static ContentProposalAdapter autoComplete(Text text, IContentProposalProvider proposalProvider) {
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)text, (IControlContentAdapter)new TextContentAdapter(), proposalProvider, null, null);
        adapter.setPropagateKeys(true);
        adapter.setProposalAcceptanceStyle(2);
        return adapter;
    }

    public static ContentProposalAdapter autoComplete(Combo combo, IContentProposalProvider proposalProvider) {
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)combo, (IControlContentAdapter)new ComboContentAdapter(), proposalProvider, null, null);
        adapter.setPropagateKeys(true);
        adapter.setProposalAcceptanceStyle(2);
        return adapter;
    }

    public static <T extends Control> T span(T control, int cols) {
        ControlBuilder.gridData(control).horizontalSpan = cols;
        return control;
    }

    public static Control createSeperator(Composite parent) {
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
        return separator;
    }

    public static <T extends Control> boolean isGridLayouted(T control) {
        return control.getParent().getLayout() instanceof GridLayout;
    }

    public static GridData gridData(Control control) {
        Object layoutData = control.getLayoutData();
        if (layoutData instanceof GridData) {
            return (GridData)layoutData;
        }
        GridData gridData = new GridData();
        if (ControlBuilder.isGridLayouted(control)) {
            control.setLayoutData((Object)gridData);
        }
        return gridData;
    }

    public static TableViewer createTable(Composite parent, boolean enableTooltips) {
        Composite layoutContainer = ControlBuilder.maximize(new Composite(parent, 0));
        layoutContainer.setLayout((Layout)new TableColumnLayout());
        TableViewer viewer = new TableViewer(layoutContainer, 68354);
        viewer.getTable().setLinesVisible(true);
        viewer.getTable().setHeaderVisible(true);
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        if (enableTooltips) {
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer, (int)2);
        }
        return viewer;
    }

    public static TreeViewer createTreeTable(Composite parent, boolean enableTooltips) {
        TreeViewer treeViewer = new TreeViewer(parent, 68354);
        treeViewer.setUseHashlookup(true);
        treeViewer.setExpandPreCheckFilters(true);
        treeViewer.getTree().setLinesVisible(true);
        treeViewer.getTree().setHeaderVisible(true);
        if (enableTooltips) {
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)treeViewer, (int)2);
        }
        return treeViewer;
    }

    public static TreeViewerColumn createEmptyColumn(TreeViewer treeViewer) {
        return ControlBuilder.createColumn(treeViewer, "", 1, new CellLabelProvider(){

            public void update(ViewerCell cell) {
            }
        });
    }

    public static TreeViewerColumn createColumn(TreeViewer treeViewer, String text, int width, CellLabelProvider labelProvider) {
        TreeViewerColumn column = new TreeViewerColumn(treeViewer, 0);
        column.getColumn().setText(text);
        column.getColumn().setWidth(width);
        if (labelProvider != null) {
            column.setLabelProvider(labelProvider);
        }
        return column;
    }

    public static TreeViewerColumn createColumn(TreeViewer treeViewer, ColumnDefinition<?, ?> definition) {
        return ControlBuilder.createColumn(treeViewer, definition, false);
    }

    public static TreeViewerColumn createColumn(TreeViewer treeViewer, ColumnDefinition<?, ?> definition, boolean editEnabled) {
        EditingSupport editingSupport;
        TreeViewerColumn column = new TreeViewerColumn(treeViewer, definition.getStyle());
        column.getColumn().setText(definition.getTitle());
        column.getColumn().setWidth(definition.getWidth());
        CellLabelProvider labelProvider = definition.getLabelProvider();
        if (labelProvider != null) {
            column.setLabelProvider(labelProvider);
        }
        if (editEnabled && (editingSupport = definition.getEditingSupport((ColumnViewer)treeViewer)) != null) {
            column.setEditingSupport(editingSupport);
        }
        return column;
    }

    public static List<TableViewerColumn> createColumns(TableViewer viewer, ColumnDefinitionProvider provider, boolean editEnabled) {
        ArrayList<TableViewerColumn> list = new ArrayList<TableViewerColumn>();
        for (ColumnDefinition<?, ?> definition : provider.getColumnDefinitions()) {
            list.add(ControlBuilder.createColumn(viewer, definition, editEnabled));
        }
        return list;
    }

    public static TableViewerColumn createColumn(TableViewer viewer, ColumnDefinition<?, ?> definition) {
        return ControlBuilder.createColumn(viewer, definition, false);
    }

    public static TableViewerColumn createColumn(TableViewer viewer, ColumnDefinition<?, ?> definition, boolean editEnabled) {
        Layout layout;
        EditingSupport editingSupport;
        TableViewerColumn tableViewerColumn = new TableViewerColumn(viewer, definition.getStyle());
        TableColumn tableColumn = tableViewerColumn.getColumn();
        tableColumn.setText(definition.getTitle());
        int width = definition.getWidth();
        boolean resizable = definition.isResizable();
        tableColumn.setWidth(width);
        tableColumn.setResizable(resizable);
        tableColumn.setMoveable(false);
        CellLabelProvider labelProvider = definition.getLabelProvider();
        if (labelProvider != null) {
            tableViewerColumn.setLabelProvider(labelProvider);
        }
        if (editEnabled && (editingSupport = definition.getEditingSupport((ColumnViewer)viewer)) != null) {
            tableViewerColumn.setEditingSupport(editingSupport);
        }
        if ((layout = viewer.getControl().getParent().getLayout()) instanceof TableColumnLayout) {
            ((TableColumnLayout)layout).setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(definition.getWidth(), definition.getMinWidth(), resizable));
        }
        return tableViewerColumn;
    }
}

