/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.preferences.fieldeditors;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class RetentionTimeMinutesFieldEditor
extends StringFieldEditor {
    private double minRetentionTimeMinutes = -2.147483648E9;
    private double maxRetentionTimeMinutes = 2.147483647E9;
    private double MINUTE_CORRELATION_FACTOR = 60000.0;
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish();

    public RetentionTimeMinutesFieldEditor(String name, String labelText, int minRetentionTimeMilliseconds, int maxRetentionTimeMilliseconds, Composite parent) {
        super(name, labelText, parent);
        this.minRetentionTimeMinutes = (double)minRetentionTimeMilliseconds / this.MINUTE_CORRELATION_FACTOR;
        this.maxRetentionTimeMinutes = (double)maxRetentionTimeMilliseconds / this.MINUTE_CORRELATION_FACTOR;
    }

    protected boolean checkState() {
        block4: {
            Text textControl = this.getTextControl();
            if (textControl == null) {
                return false;
            }
            String stringValue = textControl.getText();
            double value = Double.valueOf(stringValue);
            if (!(value >= this.minRetentionTimeMinutes) || !(value <= this.maxRetentionTimeMinutes)) break block4;
            this.clearErrorMessage();
            return true;
        }
        try {
            this.setAndShowErrorMessage();
        }
        catch (NumberFormatException e) {
            this.setAndShowErrorMessage();
        }
        return false;
    }

    protected void doLoad() {
        Text textControl = this.getTextControl();
        if (textControl != null) {
            Double retentionTimeMinutes = (double)this.getPreferenceStore().getInt(this.getPreferenceName()) / this.MINUTE_CORRELATION_FACTOR;
            textControl.setText(retentionTimeMinutes.toString());
            this.oldValue = this.getPreferenceStore().getString(this.getPreferenceName());
        }
    }

    protected void doLoadDefault() {
        Text textControl = this.getTextControl();
        if (textControl != null) {
            Double value = (double)this.getPreferenceStore().getDefaultInt(this.getPreferenceName()) / this.MINUTE_CORRELATION_FACTOR;
            textControl.setText(value.toString());
        }
        this.valueChanged();
    }

    protected void doStore() {
        Text textControl = this.getTextControl();
        if (textControl != null) {
            double value = Double.valueOf(textControl.getText());
            int retentionTime = (int)(value * this.MINUTE_CORRELATION_FACTOR);
            this.getPreferenceStore().setValue(this.getPreferenceName(), retentionTime);
        }
    }

    private void setAndShowErrorMessage() {
        this.showErrorMessage("Allowed retention time range: " + this.decimalFormat.format(this.minRetentionTimeMinutes) + " - " + this.decimalFormat.format(this.maxRetentionTimeMinutes) + " minutes");
    }
}

