/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.parts;

import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.support.history.IEditHistory;
import org.eclipse.chemclipse.support.ui.swt.EditHistoryListUI;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class EditHistoryPart {
    private EPartService partService;
    private MPart part;
    private IEventBroker eventBroker;
    private EventHandler eventHandler = null;
    private EditHistoryListUI editHistoryListUI;
    private IEditHistory editHistory;

    @Inject
    public EditHistoryPart(Composite parent, EPartService partService, MPart part, IEventBroker eventBroker) {
        this.partService = partService;
        this.part = part;
        this.eventBroker = eventBroker;
        this.createControl(parent);
        this.subscribe();
    }

    private void createControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.editHistoryListUI = new EditHistoryListUI(parent, 770);
    }

    @Focus
    public void setFocus() {
        this.editHistoryListUI.getControl().setFocus();
        this.update();
    }

    public void setInput(IEditHistory editHistory) {
        this.editHistory = editHistory;
        this.update();
    }

    private void update() {
        if (this.doUpdate(this.editHistory)) {
            this.editHistoryListUI.setInput(this.editHistory);
        } else {
            this.editHistoryListUI.setInput(null);
        }
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
    }

    private void subscribe() {
        if (this.eventBroker != null) {
            this.eventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    EditHistoryPart.this.editHistory = (IEditHistory)event.getProperty("org.eclipse.e4.data");
                    EditHistoryPart.this.update();
                }
            };
            this.eventBroker.subscribe("edithistory/update", this.eventHandler);
        }
    }

    private void unsubscribe() {
        if (this.eventBroker != null && this.eventHandler != null) {
            this.eventBroker.unsubscribe(this.eventHandler);
        }
    }

    private boolean isPartVisible() {
        return this.partService != null && this.partService.isPartVisible(this.part);
    }

    private boolean doUpdate(IEditHistory editHistory) {
        return this.isPartVisible() && editHistory != null;
    }
}

