/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.identifier.supplier.nist.settings;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import org.eclipse.chemclipse.chromatogram.msd.identifier.settings.AbstractPeakIdentifierSettingsMSD;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.settings.INistSettings;
import org.eclipse.chemclipse.support.settings.IntSettingsProperty;

public class PeakIdentifierSettings
extends AbstractPeakIdentifierSettingsMSD
implements INistSettings {
    @JsonProperty(value="Number of Targets", defaultValue="3")
    @JsonPropertyDescription(value="The number of iterations to targets to store.")
    @IntSettingsProperty
    private int numberOfTargets = 3;
    @JsonProperty(value="Store Targets", defaultValue="true")
    @JsonPropertyDescription(value="Shall the targets be stored.")
    private boolean storeTargets = true;
    @JsonProperty(value="Timeout (Minutes)", defaultValue="20")
    @JsonPropertyDescription(value="The timeout in minutes to stop the action if something goes wrong.")
    @IntSettingsProperty
    private int timeoutInMinutes = 20;

    @Override
    public int getNumberOfTargets() {
        return this.numberOfTargets;
    }

    @Override
    public void setNumberOfTargets(int numberOfTargets) {
        if (numberOfTargets >= 1 && numberOfTargets <= 100) {
            this.numberOfTargets = numberOfTargets;
        }
    }

    @Override
    public boolean getStoreTargets() {
        return this.storeTargets;
    }

    @Override
    public void setStoreTargets(boolean storeTargets) {
        this.storeTargets = storeTargets;
    }

    @Override
    public int getTimeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    @Override
    public void setTimeoutInMinutes(int timeoutInMinutes) {
        this.timeoutInMinutes = timeoutInMinutes;
    }
}

