/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.massbank.model;

import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.model.core.AbstractRegularLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.Ion;

public class VendorLibraryMassSpectrum
extends AbstractRegularLibraryMassSpectrum {
    private static final long serialVersionUID = -7294423367073178233L;
    private static final Logger logger = Logger.getLogger(VendorLibraryMassSpectrum.class);

    public VendorLibraryMassSpectrum makeDeepCopy() throws CloneNotSupportedException {
        VendorLibraryMassSpectrum massSpectrum = (VendorLibraryMassSpectrum)((Object)super.clone());
        for (IIon ion : this.getIons()) {
            try {
                Ion massbankIon = new Ion(ion.getIon(), ion.getAbundance());
                massSpectrum.addIon((IIon)massbankIon);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
        }
        return massSpectrum;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.makeDeepCopy();
    }
}

